/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.IValidator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.common.team.TeamProviderUtil;
import org.jabylon.properties.Project;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.PropertyType;
import org.jabylon.properties.Workspace;
import org.jabylon.rest.ui.model.AttachableModel;
import org.jabylon.rest.ui.model.EObjectPropertyModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ControlGroup;
import org.jabylon.rest.ui.wicket.validators.TerminologyProjectValidator;
import org.jabylon.rest.ui.wicket.validators.UniqueNameValidator;

public class ProjectConfigSection
extends BasicPanel<Project> {
    private static final long serialVersionUID = 1L;

    public ProjectConfigSection(String id, IModel<Project> model) {
        super(id, model, new PageParameters());
        ControlGroup nameGroup = new ControlGroup("name-group", (IModel<String>)this.nls("ProjectConfigSection.name.label", new Object[0]));
        EObjectPropertyModel nameProperty = new EObjectPropertyModel(model, (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__NAME);
        RequiredTextField field = new RequiredTextField("inputName", nameProperty);
        field.add((IValidator)new UniqueNameValidator(ProjectConfigSection.getUsedProjectNames(model)));
        nameGroup.add(new Component[]{field});
        this.add(new Component[]{nameGroup});
        ControlGroup typeGroup = new ControlGroup("type-group", (IModel<String>)this.nls("ProjectConfigSection.project.type.choice", new Object[0]));
        EObjectPropertyModel typeModel = new EObjectPropertyModel(model, (EStructuralFeature)PropertiesPackage.Literals.PROJECT__PROPERTY_TYPE);
        DropDownChoice typeChoice = new DropDownChoice("inputType", typeModel, PropertyType.VALUES);
        typeGroup.add(new Component[]{typeChoice});
        this.add(new Component[]{typeGroup});
        ArrayList<String> teamProviders = new ArrayList<String>();
        List availableTeamProviders = TeamProviderUtil.getAvailableTeamProviders();
        teamProviders.add("None");
        teamProviders.addAll(availableTeamProviders);
        ControlGroup teamproviderGroup = new ControlGroup("teamprovider-group", (IModel<String>)this.nls("ProjectConfigSection.team.provider.choice", new Object[0]));
        EObjectPropertyModel teamProviderModel = new EObjectPropertyModel(model, (EStructuralFeature)PropertiesPackage.Literals.PROJECT__TEAM_PROVIDER);
        DropDownChoice teamProviderChoice = new DropDownChoice("inputTeamProvider", teamProviderModel, teamProviders);
        teamproviderGroup.add(new Component[]{teamProviderChoice});
        this.add(new Component[]{teamproviderGroup});
        ControlGroup terminologyGroup = new ControlGroup("terminology-group", (IModel<String>)this.nls("ProjectConfigSection.terminology.label", new Object[0]), (IModel<String>)this.nls("ProjectConfigSection.terminology.description", new Object[0]));
        EObjectPropertyModel terminologyModel = new EObjectPropertyModel(model, (EStructuralFeature)PropertiesPackage.Literals.PROJECT__TERMINOLOGY);
        CheckBox terminology = new CheckBox("inputTerminology", terminologyModel);
        terminology.add((IValidator)new TerminologyProjectValidator(model));
        this.add(new Component[]{terminologyGroup});
        terminologyGroup.add(new Component[]{terminology});
    }

    private static Set<String> getUsedProjectNames(IModel<Project> model) {
        AttachableModel a;
        Object parent;
        Workspace workspace = (Workspace)((Project)model.getObject()).getParent();
        if (workspace == null && model instanceof AttachableModel && (parent = (a = (AttachableModel)model).getParent().getObject()) instanceof Workspace) {
            workspace = (Workspace)parent;
        }
        HashSet<String> usedNames = new HashSet<String>();
        if (workspace != null) {
            for (Project project : workspace.getChildren()) {
                if (project == model.getObject()) continue;
                usedNames.add(project.getName());
            }
        }
        return usedNames;
    }
}

