/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.common.progress.RunnableWithProgress;
import org.jabylon.common.team.TeamProvider;
import org.jabylon.common.team.TeamProviderException;
import org.jabylon.common.team.TeamProviderUtil;
import org.jabylon.common.util.FileUtil;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.PropertyFileDiff;
import org.jabylon.properties.ScanConfiguration;
import org.jabylon.resources.persistence.PropertyPersistenceService;
import org.jabylon.rest.ui.Activator;
import org.jabylon.rest.ui.model.ComplexEObjectListDataProvider;
import org.jabylon.rest.ui.model.ProgressionModel;
import org.jabylon.rest.ui.util.WicketUtil;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ProgressPanel;
import org.jabylon.rest.ui.wicket.components.ProgressShowingAjaxButton;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.rest.ui.wicket.config.SettingsPage;
import org.jabylon.security.CommonPermissions;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectVersionsConfigSection
extends BasicPanel<Project> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ProjectVersionsConfigSection.class);

    public ProjectVersionsConfigSection(String id, IModel<Project> model, Preferences config) {
        super(id, model);
        this.add(new Component[]{this.buildAddNewLink(model)});
        ComplexEObjectListDataProvider provider = new ComplexEObjectListDataProvider(model, (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__CHILDREN);
        ListView<ProjectVersion> project = new ListView<ProjectVersion>("versions", provider){
            private static final long serialVersionUID = 1L;
            private ProgressionModel progressModel;

            protected void populateItem(ListItem<ProjectVersion> item) {
                item.setOutputMarkupId(true);
                item.add(new Component[]{new Label("name", ((ProjectVersion)item.getModelObject()).getName())});
                item.add(new Component[]{new Label("summary", (IModel)new StringResourceModel("ProjectVersionsConfigSection.summary", item, null, new Object[]{((ProjectVersion)item.getModel().getObject()).getChildren().size()}))});
                this.progressModel = new ProgressionModel("");
                ProgressPanel progressPanel = new ProgressPanel("progress", this.progressModel);
                item.add(new Component[]{progressPanel});
                ProjectVersion projectVersion = (ProjectVersion)item.getModelObject();
                item.add(new Component[]{new BookmarkablePageLink("edit", SettingsPage.class, WicketUtil.buildPageParametersFor(projectVersion))});
                item.add(new Component[]{ProjectVersionsConfigSection.this.createCheckoutAction(progressPanel, (IModel<ProjectVersion>)item.getModel())});
                item.add(new Component[]{ProjectVersionsConfigSection.this.createRescanAction(progressPanel, (IModel<ProjectVersion>)item.getModel())});
                item.add(new Component[]{ProjectVersionsConfigSection.this.createUpdateAction(progressPanel, (IModel<ProjectVersion>)item.getModel())});
                item.add(new Component[]{ProjectVersionsConfigSection.this.createResetAction(progressPanel, (IModel<ProjectVersion>)item.getModel())});
                item.add(new Component[]{ProjectVersionsConfigSection.this.createCommitAction(progressPanel, (IModel<ProjectVersion>)item.getModel())});
                item.add(new Component[]{ProjectVersionsConfigSection.this.createDeleteAction(progressPanel, (IModel<ProjectVersion>)item.getModel())});
            }
        };
        project.setReuseItems(true);
        project.setOutputMarkupId(true);
        this.add(new Component[]{project});
    }

    private Component buildAddNewLink(IModel<Project> model) {
        Project project = (Project)model.getObject();
        if (project.cdoState() == CDOState.NEW || project.cdoState() == CDOState.TRANSIENT) {
            Button link = new Button("addNew");
            link.setEnabled(false);
            return link;
        }
        PageParameters parameters = WicketUtil.buildPageParametersFor(project);
        parameters.add("create", (Object)PropertiesPackage.Literals.PROJECT_VERSION.getName());
        return new BookmarkablePageLink("addNew", SettingsPage.class, parameters);
    }

    protected Component createDeleteAction(ProgressPanel progressPanel, IModel<ProjectVersion> model) {
        DeleteAction button = new DeleteAction("delete", model, (IModel<String>)this.nls("ProjectVersionsConfigSection.delete.action.confirmation", ((ProjectVersion)model.getObject()).getName()));
        button.setDefaultFormProcessing(false);
        return button;
    }

    protected Component createUpdateAction(ProgressPanel progressPanel, final IModel<ProjectVersion> model) {
        RunnableWithProgress runnable = new RunnableWithProgress(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus run(IProgressMonitor monitor) {
                ProjectVersion version = (ProjectVersion)model.getObject();
                TeamProvider provider = TeamProviderUtil.getTeamProvider((String)((Project)version.getParent()).getTeamProvider());
                CDOTransaction transaction = Activator.getDefault().getRepositoryConnector().openTransaction();
                try {
                    version = (ProjectVersion)transaction.getObject((EObject)version);
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Updating", (int)100);
                    Collection updates = provider.update(version, (IProgressMonitor)subMonitor.newChild(50));
                    subMonitor.setWorkRemaining(updates.size() * 2);
                    subMonitor.subTask("Processing updates");
                    for (PropertyFileDiff updatedFile : updates) {
                        version.partialScan(PreferencesUtil.getScanConfigForProject((Project)((Project)ProjectVersionsConfigSection.this.getModelObject())), updatedFile);
                        subMonitor.worked(1);
                    }
                    subMonitor.setTaskName("Database Sync");
                    transaction.commit((IProgressMonitor)subMonitor.newChild(updates.size()));
                }
                catch (TeamProviderException e) {
                    logger.error("Update failed", (Throwable)e);
                    Status status = new Status(4, "org.jabylon.rest.ui", "Update failed", (Throwable)e);
                    return status;
                }
                catch (CommitException e) {
                    logger.error("Failed to commit the transaction", (Throwable)e);
                    Status status = new Status(4, "org.jabylon.rest.ui", "Failed to commit the transaction", (Throwable)e);
                    return status;
                }
                finally {
                    transaction.close();
                    PropertyPersistenceService persistenceService = Activator.getDefault().getPersistenceService();
                    if (persistenceService != null) {
                        persistenceService.clearCache();
                    } else {
                        logger.error("Could not obtain property persistence service");
                    }
                }
                return Status.OK_STATUS;
            }
        };
        return new ProgressShowingAjaxButton("update", progressPanel, runnable, (IModel)this.nls("update.version.job.label", ((Project)this.getModelObject()).getName())){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                ProjectVersion version = (ProjectVersion)model.getObject();
                TeamProvider provider = TeamProviderUtil.getTeamProvider((String)((Project)version.getParent()).getTeamProvider());
                if (provider == null) {
                    return false;
                }
                File file = new File(version.absoluteFilePath().toFileString());
                return file.isDirectory();
            }
        };
    }

    protected Component createResetAction(ProgressPanel progressPanel, final IModel<ProjectVersion> model) {
        RunnableWithProgress runnable = new RunnableWithProgress(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus run(IProgressMonitor monitor) {
                ProjectVersion version = (ProjectVersion)model.getObject();
                TeamProvider provider = TeamProviderUtil.getTeamProvider((String)((Project)version.getParent()).getTeamProvider());
                CDOTransaction transaction = Activator.getDefault().getRepositoryConnector().openTransaction();
                try {
                    version = (ProjectVersion)transaction.getObject((EObject)version);
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Resetting", (int)100);
                    Collection updates = provider.reset(version, (IProgressMonitor)subMonitor.newChild(50));
                    subMonitor.setWorkRemaining(updates.size() * 2);
                    subMonitor.subTask("Processing diff");
                    for (PropertyFileDiff updatedFile : updates) {
                        version.partialScan(PreferencesUtil.getScanConfigForProject((Project)((Project)ProjectVersionsConfigSection.this.getModelObject())), updatedFile);
                        subMonitor.worked(1);
                    }
                    subMonitor.setTaskName("Database Sync");
                    transaction.commit((IProgressMonitor)subMonitor.newChild(updates.size()));
                }
                catch (TeamProviderException e) {
                    logger.error("Update failed", (Throwable)e);
                    Status status = new Status(4, "org.jabylon.rest.ui", "Reset failed", (Throwable)e);
                    return status;
                }
                catch (CommitException e) {
                    logger.error("Failed to commit the transaction", (Throwable)e);
                    Status status = new Status(4, "org.jabylon.rest.ui", "Failed to commit the transaction", (Throwable)e);
                    return status;
                }
                finally {
                    transaction.close();
                    PropertyPersistenceService persistenceService = Activator.getDefault().getPersistenceService();
                    if (persistenceService != null) {
                        persistenceService.clearCache();
                    } else {
                        logger.error("Could not obtain property persistence service");
                    }
                }
                return Status.OK_STATUS;
            }
        };
        return new ProgressShowingAjaxButton("reset", progressPanel, runnable, (IModel)this.nls("reset.version.job.label", ((Project)this.getModelObject()).getName())){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                ProjectVersion version = (ProjectVersion)model.getObject();
                TeamProvider provider = TeamProviderUtil.getTeamProvider((String)((Project)version.getParent()).getTeamProvider());
                if (provider == null) {
                    return false;
                }
                File file = new File(version.absoluteFilePath().toFileString());
                return file.isDirectory();
            }
        };
    }

    protected Component createCommitAction(ProgressPanel progressPanel, final IModel<ProjectVersion> model) {
        RunnableWithProgress runnable = new RunnableWithProgress(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus run(IProgressMonitor monitor) {
                ProjectVersion version = (ProjectVersion)model.getObject();
                TeamProvider provider = TeamProviderUtil.getTeamProvider((String)((Project)version.getParent()).getTeamProvider());
                CDOTransaction transaction = Activator.getDefault().getRepositoryConnector().openTransaction();
                try {
                    version = (ProjectVersion)transaction.getObject((EObject)version);
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Committing", (int)100);
                    provider.commit(version, (IProgressMonitor)subMonitor.newChild(100));
                }
                catch (TeamProviderException e) {
                    logger.error("Commit failed", (Throwable)e);
                    Status status = new Status(4, "org.jabylon.rest.ui", "Commit Failed", (Throwable)e);
                    return status;
                }
                finally {
                    transaction.close();
                }
                return Status.OK_STATUS;
            }
        };
        return new ProgressShowingAjaxButton("commit", progressPanel, runnable, (IModel)this.nls("commit.version.job.label", ((Project)this.getModelObject()).getName())){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                ProjectVersion version = (ProjectVersion)model.getObject();
                TeamProvider provider = TeamProviderUtil.getTeamProvider((String)((Project)version.getParent()).getTeamProvider());
                if (provider == null) {
                    return false;
                }
                File file = new File(version.absoluteFilePath().toFileString());
                return file.isDirectory();
            }
        };
    }

    private Component createCheckoutAction(ProgressPanel progressPanel, final IModel<ProjectVersion> model) {
        RunnableWithProgress runnable = new RunnableWithProgress(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus run(IProgressMonitor monitor) {
                CDOTransaction transaction = Activator.getDefault().getRepositoryConnector().openTransaction();
                try {
                    ProjectVersion version = (ProjectVersion)model.getObject();
                    version = (ProjectVersion)transaction.getObject((EObject)version);
                    TeamProvider provider = TeamProviderUtil.getTeamProvider((String)((Project)version.getParent()).getTeamProvider());
                    provider.checkout(version, monitor);
                }
                catch (TeamProviderException e) {
                    logger.error("Checkout failed", (Throwable)e);
                    Status status = new Status(4, "org.jabylon.rest.ui", "Checkout failed", (Throwable)e);
                    return status;
                }
                finally {
                    try {
                        transaction.commit();
                    }
                    catch (CommitException e) {
                        logger.error("Failed to commit the transaction", (Throwable)e);
                        return new Status(4, "org.jabylon.rest.ui", "Failed to commit the transaction", (Throwable)e);
                    }
                    transaction.close();
                }
                return Status.OK_STATUS;
            }
        };
        return new ProgressShowingAjaxButton("checkout", progressPanel, runnable, (IModel)this.nls("checkout.version.job.label", ((Project)this.getModelObject()).getName())){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                ProjectVersion version = (ProjectVersion)model.getObject();
                TeamProvider provider = TeamProviderUtil.getTeamProvider((String)((Project)version.getParent()).getTeamProvider());
                if (provider == null) {
                    return false;
                }
                File file = new File(version.absoluteFilePath().toFileString());
                return !file.isDirectory();
            }
        };
    }

    private Component createRescanAction(ProgressPanel progressPanel, final IModel<ProjectVersion> model) {
        RunnableWithProgress runnable = new RunnableWithProgress(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus run(IProgressMonitor monitor) {
                ScanConfiguration scanConfiguration = PreferencesUtil.getScanConfigForProject((Project)((Project)ProjectVersionsConfigSection.this.getModelObject()));
                ProjectVersion version = (ProjectVersion)model.getObject();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Scanning", (int)100);
                CDOTransaction transaction = Activator.getDefault().getRepositoryConnector().openTransaction();
                version = (ProjectVersion)transaction.getObject((EObject)version);
                version.fullScan(scanConfiguration, (IProgressMonitor)subMonitor.newChild(50));
                subMonitor.setTaskName("Database Sync");
                try {
                    transaction.commit((IProgressMonitor)subMonitor.newChild(50));
                }
                catch (CommitException e) {
                    Status status = new Status(4, "org.jabylon.rest.ui", "Transaction commit failed", (Throwable)e);
                    return status;
                }
                finally {
                    transaction.close();
                    PropertyPersistenceService persistenceService = Activator.getDefault().getPersistenceService();
                    if (persistenceService != null) {
                        persistenceService.clearCache();
                    } else {
                        logger.error("Could not obtain property persistence service");
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        return new ProgressShowingAjaxButton("rescan", progressPanel, runnable, (IModel)this.nls("rescan.version.job.label", ((Project)this.getModelObject()).getName())){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return true;
            }
        };
    }

    static class DeleteAction
    extends IndicatingAjaxButton {
        private IModel<ProjectVersion> model;
        private IModel<String> confirmationText;
        private static final long serialVersionUID = 1L;

        public DeleteAction(String id, IModel<ProjectVersion> model, IModel<String> confirmationText) {
            super(id);
            this.model = model;
            this.confirmationText = confirmationText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onAfterSubmit(AjaxRequestTarget target, Form<?> form) {
            ProjectVersion projectVersion = (ProjectVersion)this.model.getObject();
            CDOTransaction transaction = Activator.getDefault().getRepositoryConnector().openTransaction();
            projectVersion = (ProjectVersion)transaction.getObject((EObject)projectVersion);
            Preferences preferences = PreferencesUtil.scopeFor((Object)projectVersion);
            try {
                PreferencesUtil.deleteNode((Preferences)preferences);
                File directory = new File(projectVersion.absolutPath().toFileString());
                FileUtil.delete((File)directory);
                ((Project)projectVersion.getParent()).getChildren().remove((Object)projectVersion);
                transaction.commit();
                this.setResponsePage(SettingsPage.class, this.getPage().getPageParameters());
            }
            catch (CommitException e) {
                logger.error("Commit failed", (Throwable)e);
                this.getSession().error((Serializable)((Object)e.getMessage()));
            }
            catch (BackingStoreException e) {
                logger.error("Failed to delete project preferences", (Throwable)e);
                this.getSession().error((Serializable)((Object)e.getMessage()));
            }
            finally {
                transaction.close();
            }
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            AjaxCallListener ajaxCallListener = new AjaxCallListener();
            ajaxCallListener.onPrecondition((CharSequence)("return confirm('" + (String)this.confirmationText.getObject() + "');"));
            attributes.getAjaxCallListeners().add(ajaxCallListener);
        }
    }

    public static class VersionsConfig
    extends AbstractConfigSection<Project> {
        private static final long serialVersionUID = 1L;

        @Override
        public WebMarkupContainer doCreateContents(String id, IModel<Project> input, Preferences prefs) {
            return new ProjectVersionsConfigSection(id, input, prefs);
        }

        @Override
        public void commit(IModel<Project> input, Preferences config) {
        }

        @Override
        public String getRequiredPermission() {
            String projectName = null;
            if (this.getDomainObject() != null) {
                projectName = ((Project)this.getDomainObject()).getName();
            }
            return CommonPermissions.constructPermission((String[])new String[]{"Project", projectName, "edit"});
        }
    }
}

