/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.jabylon.properties.Project;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.rest.ui.model.PreferencesPropertyModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ControlGroup;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.security.CommonPermissions;
import org.osgi.service.prefs.Preferences;

public class ScanningConfigSection
extends BasicPanel<Project> {
    private static final long serialVersionUID = 1L;

    public ScanningConfigSection(String id, IModel<Project> model, Preferences config) {
        super(id, model);
        PreferencesPropertyModel includeModel = new PreferencesPropertyModel(config, "include", PropertiesPackage.Literals.SCAN_CONFIGURATION__INCLUDE.getDefaultValueLiteral());
        ControlGroup includesGroup = new ControlGroup("includes-group", (IModel<String>)this.nls("ScanningConfigSection.includes.label", new Object[0]), (IModel<String>)this.nls("ScanningConfigSection.includes.help", new Object[0]));
        includesGroup.add(new Component[]{new TextArea("inputIncludes", (IModel)includeModel)});
        this.add(new Component[]{includesGroup});
        ControlGroup excludesGroup = new ControlGroup("excludes-group", (IModel<String>)this.nls("ScanningConfigSection.excludes.label", new Object[0]), (IModel<String>)this.nls("ScanningConfigSection.excludes.help", new Object[0]));
        PreferencesPropertyModel excludeModel = new PreferencesPropertyModel(config, "exclude", PropertiesPackage.Literals.SCAN_CONFIGURATION__EXCLUDE.getDefaultValueLiteral());
        excludesGroup.add(new Component[]{new TextArea("inputExcludes", (IModel)excludeModel)});
        this.add(new Component[]{excludesGroup});
        ControlGroup templateGroup = new ControlGroup("template-group", (IModel<String>)this.nls("ScanningConfigSection.template.locale.label", new Object[0]), (IModel<String>)this.nls("ScanningConfigSection.template.locale.help", new Object[0]));
        PreferencesPropertyModel templateLocaleModel = new PreferencesPropertyModel(config, "master.locale", PropertiesPackage.Literals.SCAN_CONFIGURATION__MASTER_LOCALE.getDefaultValueLiteral());
        templateGroup.add(new Component[]{new TextField("inputTemplateLocale", (IModel)templateLocaleModel)});
        this.add(new Component[]{templateGroup});
    }

    public static class ScanningConfig
    extends AbstractConfigSection<Project> {
        private static final long serialVersionUID = 1L;

        @Override
        public WebMarkupContainer doCreateContents(String id, IModel<Project> input, Preferences prefs) {
            return new ScanningConfigSection(id, input, prefs);
        }

        @Override
        public void commit(IModel<Project> input, Preferences config) {
        }

        @Override
        public String getRequiredPermission() {
            String projectName = null;
            if (this.getDomainObject() != null) {
                projectName = ((Project)this.getDomainObject()).getName();
            }
            return CommonPermissions.constructPermission((String[])new String[]{"Project", projectName, "edit"});
        }
    }
}

