/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections;

import java.io.File;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.common.util.FileUtil;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.properties.Project;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.Workspace;
import org.jabylon.rest.ui.Activator;
import org.jabylon.rest.ui.model.ComplexEObjectListDataProvider;
import org.jabylon.rest.ui.util.WicketUtil;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.config.SettingsPage;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceConfigSection
extends BasicPanel<Workspace> {
    private static final long serialVersionUID = -5358263608301930488L;
    private static final Logger logger = LoggerFactory.getLogger(WorkspaceConfigSection.class);

    public WorkspaceConfigSection(String id, IModel<Workspace> object, Preferences prefs) {
        super(id, object);
        this.add(new Component[]{this.buildAddNewLink(object)});
        ComplexEObjectListDataProvider provider = new ComplexEObjectListDataProvider(object, (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__CHILDREN);
        ListView<Project> project = new ListView<Project>("projects", provider){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<Project> item) {
                item.add(new Component[]{new BookmarkablePageLink("edit", SettingsPage.class, WicketUtil.buildPageParametersFor((Resolvable)item.getModelObject()))});
                item.add(new Component[]{new Label("project-name", ((Project)item.getModelObject()).getName())});
                item.add(new Component[]{WorkspaceConfigSection.this.createDeleteAction((IModel<Project>)item.getModel())});
            }
        };
        project.setReuseItems(true);
        this.add(new Component[]{project});
    }

    private Component buildAddNewLink(IModel<Workspace> model) {
        PageParameters params = WicketUtil.buildPageParametersFor((Resolvable)model.getObject());
        params.add("create", (Object)PropertiesPackage.Literals.PROJECT.getName());
        return new BookmarkablePageLink("addNew", SettingsPage.class, params);
    }

    protected Component createDeleteAction(IModel<Project> model) {
        DeleteAction button = new DeleteAction("delete", model, (IModel<String>)this.nls("WorkspaceConfigSection.delete.action.confirmation", ((Project)model.getObject()).getName()));
        button.setDefaultFormProcessing(false);
        return button;
    }

    static class DeleteAction
    extends IndicatingAjaxButton {
        private IModel<Project> model;
        private IModel<String> confirmationText;
        private static final long serialVersionUID = 1L;

        public DeleteAction(String id, IModel<Project> model, IModel<String> confirmationText) {
            super(id);
            this.model = model;
            this.confirmationText = confirmationText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onAfterSubmit(AjaxRequestTarget target, Form<?> form) {
            Project project = (Project)this.model.getObject();
            CDOTransaction transaction = Activator.getDefault().getRepositoryConnector().openTransaction();
            project = (Project)transaction.getObject((EObject)project);
            Preferences preferences = PreferencesUtil.scopeFor((Object)project);
            try {
                PreferencesUtil.deleteNode((Preferences)preferences);
                File directory = new File(project.absolutPath().toFileString());
                FileUtil.delete((File)directory);
                ((Workspace)project.getParent()).getChildren().remove((Object)project);
                transaction.commit();
                this.setResponsePage(SettingsPage.class, this.getPage().getPageParameters());
            }
            catch (CommitException e) {
                logger.error("Commit failed", (Throwable)e);
                this.getSession().error((Serializable)((Object)e.getMessage()));
            }
            catch (BackingStoreException e) {
                logger.error("Failed to delete project preferences", (Throwable)e);
                this.getSession().error((Serializable)((Object)e.getMessage()));
            }
            finally {
                transaction.close();
            }
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            AjaxCallListener ajaxCallListener = new AjaxCallListener();
            ajaxCallListener.onPrecondition((CharSequence)("return confirm('" + (String)this.confirmationText.getObject() + "');"));
            attributes.getAjaxCallListeners().add(ajaxCallListener);
        }
    }
}

