/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.markup.repeater.util.ModelIteratorAdapter;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.jabylon.common.resolver.URIResolver;
import org.jabylon.properties.Project;
import org.jabylon.rest.ui.model.EObjectModel;
import org.jabylon.rest.ui.security.RestrictedComponent;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.UserImagePanel;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.rest.ui.wicket.config.sections.security.PermissionSetting;
import org.jabylon.rest.ui.wicket.config.sections.security.PermissionSettingRenderer;
import org.jabylon.rest.ui.wicket.config.sections.security.RolePermission;
import org.jabylon.rest.ui.wicket.config.sections.security.RoleRenderer;
import org.jabylon.rest.ui.wicket.config.sections.security.UserPermission;
import org.jabylon.rest.ui.wicket.config.sections.security.UserRenderer;
import org.jabylon.security.CommonPermissions;
import org.jabylon.users.Permission;
import org.jabylon.users.Role;
import org.jabylon.users.User;
import org.jabylon.users.UserManagement;
import org.jabylon.users.UsersFactory;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPermissionsConfigSection
extends BasicPanel<Project>
implements RestrictedComponent {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ProjectPermissionsConfigSection.class);
    @Inject
    private URIResolver resolver;
    private IModel<UserManagement> userManagement;
    private List<UserPermission> userPermissions;
    private List<IModel<User>> assignableUsers;
    private List<RolePermission> rolePermissions;
    private List<IModel<Role>> assignableRoles;

    public ProjectPermissionsConfigSection(String id, IModel<Project> model, PageParameters params) {
        super(id, model, params);
    }

    @Override
    protected void preConstruct() {
        Object resolved = this.resolver.resolve("security");
        if (resolved instanceof UserManagement) {
            UserManagement management = (UserManagement)resolved;
            this.userManagement = new EObjectModel<UserManagement>(management);
            this.assignableUsers = new ArrayList<IModel<User>>();
            this.userPermissions = this.createUserPermissions((Project)this.getModel().getObject(), (UserManagement)this.userManagement.getObject(), this.assignableUsers);
            this.assignableRoles = new ArrayList<IModel<Role>>();
            this.rolePermissions = this.createRolePermissions((Project)this.getModel().getObject(), (UserManagement)this.userManagement.getObject(), this.assignableRoles);
        }
    }

    private List<UserPermission> createUserPermissions(Project project, UserManagement userManagement, List<IModel<User>> assignableUsers) {
        EList users = userManagement.getUsers();
        ArrayList<UserPermission> result = new ArrayList<UserPermission>();
        for (User user : users) {
            boolean filterUser = user.hasPermission("*");
            PermissionSetting highestSetting = PermissionSetting.NONE;
            EList allPermissions = user.getPermissions();
            for (Permission permission : allPermissions) {
                String permissionName = permission.getName();
                if (!permissionName.startsWith(CommonPermissions.constructPermission((String[])new String[]{"Project", project.getName()}))) continue;
                if (permissionName.endsWith("edit")) {
                    highestSetting = PermissionSetting.values()[Math.max(highestSetting.ordinal(), PermissionSetting.EDIT.ordinal())];
                }
                highestSetting = permissionName.endsWith("suggest") ? PermissionSetting.values()[Math.max(highestSetting.ordinal(), PermissionSetting.SUGGEST.ordinal())] : (permissionName.endsWith("view") ? PermissionSetting.values()[Math.max(highestSetting.ordinal(), PermissionSetting.READ.ordinal())] : PermissionSetting.CONFIG);
                filterUser = true;
            }
            if (highestSetting != PermissionSetting.NONE) {
                UserPermission userPermission = new UserPermission(new EObjectModel<User>(user), highestSetting);
                result.add(userPermission);
            }
            if (filterUser) continue;
            assignableUsers.add(new EObjectModel<User>(user));
        }
        return result;
    }

    private List<RolePermission> createRolePermissions(Project project, UserManagement userManagement, List<IModel<Role>> assignableRoles) {
        EList roles = userManagement.getRoles();
        ArrayList<RolePermission> result = new ArrayList<RolePermission>();
        for (Role role : roles) {
            boolean filterUser = this.hasPermission(role, "*");
            PermissionSetting highestSetting = PermissionSetting.NONE;
            EList allPermissions = role.getPermissions();
            for (Permission permission : allPermissions) {
                String permissionName = permission.getName();
                if (!permissionName.startsWith(CommonPermissions.constructPermission((String[])new String[]{"Project", project.getName()}))) continue;
                highestSetting = permissionName.endsWith("edit") ? PermissionSetting.values()[Math.max(highestSetting.ordinal(), PermissionSetting.EDIT.ordinal())] : (permissionName.endsWith("suggest") ? PermissionSetting.values()[Math.max(highestSetting.ordinal(), PermissionSetting.SUGGEST.ordinal())] : (permissionName.endsWith("view") ? PermissionSetting.values()[Math.max(highestSetting.ordinal(), PermissionSetting.READ.ordinal())] : PermissionSetting.CONFIG));
                filterUser = true;
            }
            if (highestSetting != PermissionSetting.NONE) {
                RolePermission rolePermission = new RolePermission(new EObjectModel<Role>(role), highestSetting);
                result.add(rolePermission);
            }
            if (filterUser) continue;
            assignableRoles.add(new EObjectModel<Role>(role));
        }
        return result;
    }

    private boolean hasPermission(Role role, String permissionName) {
        EList allPermissions = role.getAllPermissions();
        for (Permission permission : allPermissions) {
            if (!permission.getName().equals(permissionName)) continue;
            return true;
        }
        return false;
    }

    protected void onDetach() {
        if (this.userManagement != null) {
            this.userManagement.detach();
        }
        if (this.assignableUsers != null) {
            for (IModel<User> iModel : this.assignableUsers) {
                iModel.detach();
            }
        }
        if (this.assignableRoles != null) {
            for (IModel<User> iModel : this.assignableRoles) {
                iModel.detach();
            }
        }
        super.onDetach();
    }

    @Override
    protected void construct() {
        this.setOutputMarkupId(true);
        RefreshingView<RolePermission> roleDataView = new RefreshingView<RolePermission>("rolePermissionRow"){
            private static final long serialVersionUID = 1L;

            protected Iterator<IModel<RolePermission>> getItemModels() {
                ModelIteratorAdapter<RolePermission> adapter = new ModelIteratorAdapter<RolePermission>(ProjectPermissionsConfigSection.this.rolePermissions.iterator()){

                    protected IModel<RolePermission> model(RolePermission object) {
                        return new CompoundPropertyModel((Object)object);
                    }
                };
                return adapter;
            }

            protected void populateItem(Item<RolePermission> item) {
                item.add(new Component[]{new Label("registrant", ((Role)((RolePermission)item.getModelObject()).getRegistrant().getObject()).getName())});
                final DropDownChoice permissionChoice = new DropDownChoice("permission", Arrays.asList(PermissionSetting.values()), (IChoiceRenderer)new PermissionSettingRenderer());
                permissionChoice.setOutputMarkupId(true);
                permissionChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                    private static final long serialVersionUID = 1L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        target.add(new Component[]{permissionChoice});
                    }
                }});
                item.add(new Component[]{permissionChoice});
            }
        };
        this.add(new Component[]{roleDataView});
        this.addAddRolePermissionForm(this.assignableRoles);
        RefreshingView<UserPermission> dataView = new RefreshingView<UserPermission>("userPermissionRow"){
            private static final long serialVersionUID = 1L;

            protected Iterator<IModel<UserPermission>> getItemModels() {
                ModelIteratorAdapter<UserPermission> adapter = new ModelIteratorAdapter<UserPermission>(ProjectPermissionsConfigSection.this.userPermissions.iterator()){

                    protected IModel<UserPermission> model(UserPermission object) {
                        return new CompoundPropertyModel((Object)object);
                    }
                };
                return adapter;
            }

            protected void populateItem(Item<UserPermission> item) {
                item.add(new Component[]{new UserImagePanel("registrant", ((UserPermission)item.getModelObject()).getRegistrant())});
                final DropDownChoice permissionChoice = new DropDownChoice("permission", Arrays.asList(PermissionSetting.values()), (IChoiceRenderer)new PermissionSettingRenderer());
                permissionChoice.setOutputMarkupId(true);
                permissionChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                    private static final long serialVersionUID = 1L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        target.add(new Component[]{permissionChoice});
                    }
                }});
                item.add(new Component[]{permissionChoice});
            }
        };
        this.add(new Component[]{dataView});
        this.addAddPermissionForm(this.assignableUsers);
    }

    protected void commit() {
        Permission perm;
        PermissionSetting permSetting;
        Iterator it;
        EList userPermissions;
        String prefix;
        UserManagement management = (UserManagement)this.resolver.resolveWithTransaction(((UserManagement)this.userManagement.getObject()).cdoID());
        for (UserPermission userPermission : this.userPermissions) {
            User user = (User)userPermission.getRegistrant().getObject();
            user = (User)management.cdoView().getObject((EObject)user);
            prefix = CommonPermissions.constructPermission((String[])new String[]{"Project", ((Project)this.getModel().getObject()).getName()});
            userPermissions = user.getPermissions();
            it = userPermissions.iterator();
            while (it.hasNext()) {
                if (!((Permission)it.next()).getName().startsWith(prefix)) continue;
                it.remove();
            }
            permSetting = userPermission.getPermission();
            if (permSetting == PermissionSetting.NONE) continue;
            perm = this.getOrCreatePermission(CommonPermissions.constructPermissionName((String)"Project", (String)((Project)this.getModel().getObject()).getName(), (String)permSetting.getPermissionName()), management);
            user.getPermissions().add((Object)perm);
        }
        for (RolePermission rolePermission : this.rolePermissions) {
            Role role = (Role)rolePermission.getRegistrant().getObject();
            role = (Role)management.cdoView().getObject((EObject)role);
            prefix = CommonPermissions.constructPermission((String[])new String[]{"Project", ((Project)this.getModel().getObject()).getName()});
            userPermissions = role.getPermissions();
            it = userPermissions.iterator();
            while (it.hasNext()) {
                if (!((Permission)it.next()).getName().startsWith(prefix)) continue;
                it.remove();
            }
            permSetting = rolePermission.getPermission();
            if (permSetting == PermissionSetting.NONE) continue;
            perm = this.getOrCreatePermission(CommonPermissions.constructPermissionName((String)"Project", (String)((Project)this.getModel().getObject()).getName(), (String)permSetting.getPermissionName()), management);
            role.getPermissions().add((Object)perm);
        }
        CDOTransaction transaction = (CDOTransaction)management.cdoView();
        try {
            transaction.commit();
        }
        catch (CommitException commitException) {
            logger.error("Failed to commit new permission settings", (Throwable)commitException);
        }
    }

    private Permission getOrCreatePermission(String permissionName, UserManagement management) {
        Permission permission = management.findPermissionByName(permissionName);
        if (permission == null) {
            permission = UsersFactory.eINSTANCE.createPermission();
            management.getPermissions().add((Object)permission);
            permission.setName(permissionName);
        }
        return permission;
    }

    private void addAddPermissionForm(final List<IModel<User>> assignableUsers) {
        CompoundPropertyModel addPermissionModel = new CompoundPropertyModel((Object)new UserPermission());
        Form addPermissionForm = new Form("addUserPermissionForm", (IModel)addPermissionModel);
        DropDownChoice registrantChoice = new DropDownChoice("registrant", assignableUsers, (IChoiceRenderer)new UserRenderer());
        addPermissionForm.add(new Component[]{registrantChoice});
        addPermissionForm.add(new Component[]{new DropDownChoice("permission", Arrays.asList(PermissionSetting.values()), (IChoiceRenderer)new PermissionSettingRenderer())});
        AjaxButton button = new AjaxButton("addPermissionButton", addPermissionForm){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                UserPermission userPermission = (UserPermission)form.getModel().getObject();
                if (userPermission.getPermission() == null) {
                    return;
                }
                UserPermission copy = new UserPermission(userPermission.getRegistrant(), userPermission.getPermission());
                ProjectPermissionsConfigSection.this.userPermissions.add(copy);
                Collections.sort(ProjectPermissionsConfigSection.this.userPermissions);
                assignableUsers.remove(userPermission.getRegistrant());
                target.add(new Component[]{ProjectPermissionsConfigSection.this});
            }
        };
        addPermissionForm.add(new Component[]{button});
        if (assignableUsers.isEmpty()) {
            addPermissionForm.setVisible(false);
        } else {
            registrantChoice.setDefaultModelObject(assignableUsers.get(0));
        }
        this.add(new Component[]{addPermissionForm});
    }

    private void addAddRolePermissionForm(final List<IModel<Role>> assignableRoles) {
        CompoundPropertyModel addPermissionModel = new CompoundPropertyModel((Object)new RolePermission());
        Form addPermissionForm = new Form("addRolePermissionForm", (IModel)addPermissionModel);
        DropDownChoice registrantChoice = new DropDownChoice("registrant", assignableRoles, (IChoiceRenderer)new RoleRenderer());
        addPermissionForm.add(new Component[]{registrantChoice});
        addPermissionForm.add(new Component[]{new DropDownChoice("permission", Arrays.asList(PermissionSetting.values()), (IChoiceRenderer)new PermissionSettingRenderer())});
        AjaxButton button = new AjaxButton("addPermissionButton", addPermissionForm){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                RolePermission rolePermission = (RolePermission)form.getModel().getObject();
                if (rolePermission.getPermission() == null) {
                    return;
                }
                RolePermission copy = new RolePermission(rolePermission.getRegistrant(), rolePermission.getPermission());
                ProjectPermissionsConfigSection.this.rolePermissions.add(copy);
                Collections.sort(ProjectPermissionsConfigSection.this.rolePermissions);
                assignableRoles.remove(rolePermission.getRegistrant());
                target.add(new Component[]{ProjectPermissionsConfigSection.this});
            }
        };
        addPermissionForm.add(new Component[]{button});
        if (assignableRoles.isEmpty()) {
            addPermissionForm.setVisible(false);
        } else {
            registrantChoice.setDefaultModelObject(assignableRoles.get(0));
        }
        this.add(new Component[]{addPermissionForm});
    }

    @Override
    public String getRequiredPermission() {
        return CommonPermissions.constructPermissionName((String)"Project", (String)((Project)this.getModelObject()).getName(), (String)"config");
    }

    public static class ProjectPermissionsConfigSectionContributor
    extends AbstractConfigSection<Project> {
        private static final long serialVersionUID = 1L;
        private ProjectPermissionsConfigSection projectPermissionsConfigSection;

        @Override
        public WebMarkupContainer doCreateContents(String id, IModel<Project> input, Preferences config) {
            this.projectPermissionsConfigSection = new ProjectPermissionsConfigSection(id, input, new PageParameters());
            return this.projectPermissionsConfigSection;
        }

        @Override
        public void commit(IModel<Project> input, Preferences config) {
            this.projectPermissionsConfigSection.commit();
        }

        @Override
        public String getRequiredPermission() {
            String projectName = null;
            if (this.getDomainObject() != null) {
                projectName = ((Project)this.getDomainObject()).getName();
            }
            return CommonPermissions.constructPermissionName((String)"Project", projectName, (String)"config");
        }
    }
}

