/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidator;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.cdo.connector.Modification;
import org.jabylon.cdo.connector.TransactionUtil;
import org.jabylon.common.resolver.URIResolver;
import org.jabylon.properties.Project;
import org.jabylon.properties.Workspace;
import org.jabylon.rest.ui.model.AbstractEMFModel;
import org.jabylon.rest.ui.model.AttachableModel;
import org.jabylon.rest.ui.model.EObjectPropertyModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ControlGroup;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.rest.ui.wicket.validators.UniqueNameValidator;
import org.jabylon.security.CommonPermissions;
import org.jabylon.users.Permission;
import org.jabylon.users.Role;
import org.jabylon.users.UserManagement;
import org.jabylon.users.UsersFactory;
import org.jabylon.users.UsersPackage;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RolePermissionsConfigSection
extends BasicPanel<Role> {
    private static final long serialVersionUID = 1L;
    @Inject
    private URIResolver resolver;
    private static final Logger LOG = LoggerFactory.getLogger(RolePermissionsConfigSection.class);

    public RolePermissionsConfigSection(String id, IModel<Role> model) {
        super(id, model);
        ControlGroup rolenameGroup = new ControlGroup("rolename-group", (IModel<String>)this.nls("rolename", new Object[0]));
        RequiredTextField rolename = new RequiredTextField("rolename", new EObjectPropertyModel(model, (EStructuralFeature)UsersPackage.Literals.ROLE__NAME));
        rolenameGroup.add(new Component[]{rolename});
        this.add(new Component[]{rolenameGroup});
        Role role = (Role)model.getObject();
        EObject container = role.eContainer();
        UserManagement management = null;
        if (model instanceof AttachableModel) {
            AttachableModel m = (AttachableModel)model;
            management = (UserManagement)m.getParent().getObject();
        } else {
            management = (UserManagement)container;
        }
        HashSet<String> usedRolenames = new HashSet<String>();
        for (Role other : management.getRoles()) {
            if (other == role) continue;
            usedRolenames.add(other.getName());
        }
        PermissionSettingModel selected = new PermissionSettingModel(model, management);
        IModel available = Model.ofList(this.computePossiblePermissions(management));
        rolename.add((IValidator)new UniqueNameValidator(usedRolenames));
        Palette palette = new Palette("palette", (IModel)selected, available, (IChoiceRenderer)new Renderer(), 10, false);
        this.add(new Component[]{palette});
    }

    public List<String> computePossiblePermissions(UserManagement management) {
        Workspace workspace = (Workspace)this.resolver.resolve("workspace");
        TreeSet<String> permissions = new TreeSet<String>();
        EList available = management.getPermissions();
        for (Permission permission : available) {
            permissions.add(permission.getName());
        }
        EList children = workspace.getChildren();
        for (Project project : children) {
            String name = project.getName();
            permissions.add(CommonPermissions.constructPermissionName((String)"Project", (String)name, (String)"config"));
            permissions.add(CommonPermissions.constructPermissionName((String)"Project", (String)name, (String)"edit"));
            permissions.add(CommonPermissions.constructPermissionName((String)"Project", (String)name, (String)"suggest"));
            permissions.add(CommonPermissions.constructPermissionName((String)"Project", (String)name, (String)"view"));
        }
        permissions.add(CommonPermissions.constructPermissionName((String)"Project", (String)"*", (String)"config"));
        permissions.add(CommonPermissions.constructPermissionName((String)"Project", (String)"*", (String)"edit"));
        permissions.add(CommonPermissions.constructPermissionName((String)"Project", (String)"*", (String)"suggest"));
        permissions.add(CommonPermissions.constructPermissionName((String)"Project", (String)"*", (String)"view"));
        return new ArrayList<String>(permissions);
    }

    private static class PermissionSettingModel
    extends AbstractEMFModel<UserManagement, List<? extends String>> {
        private static final long serialVersionUID = 1L;
        private IModel<Role> model;

        public PermissionSettingModel(IModel<Role> model, UserManagement management) {
            super(management);
            this.model = model;
        }

        public List<String> getObject() {
            EList permissions = ((Role)this.model.getObject()).getPermissions();
            ArrayList<String> names = new ArrayList<String>(permissions.size());
            for (Permission permission : permissions) {
                names.add(permission.getName());
            }
            return names;
        }

        public void setObject(List<? extends String> object) {
            Role role = (Role)this.model.getObject();
            UserManagement management = (UserManagement)this.getDomainObject();
            EList permissions = management.getPermissions();
            HashMap<String, Permission> permissionMap = new HashMap<String, Permission>();
            for (Permission permission : permissions) {
                permissionMap.put(permission.getName(), permission);
            }
            final ArrayList<Permission> missingPermissions = new ArrayList<Permission>();
            role.getPermissions().clear();
            for (String string : object) {
                Permission permission = (Permission)permissionMap.get(string);
                if (permission == null) {
                    permission = UsersFactory.eINSTANCE.createPermission();
                    permission.setName(string);
                    missingPermissions.add(permission);
                }
                role.getPermissions().add((Object)permission);
            }
            if (!missingPermissions.isEmpty()) {
                try {
                    TransactionUtil.commit((EObject)management, (Modification)new Modification<UserManagement, UserManagement>(){

                        public UserManagement apply(UserManagement object) {
                            object.getPermissions().addAll((Collection)missingPermissions);
                            return object;
                        }
                    });
                }
                catch (CommitException e) {
                    LOG.error("Failed to add missing permissions: " + missingPermissions, (Throwable)e);
                }
            }
        }
    }

    private static class Renderer
    implements IChoiceRenderer<String> {
        private static final long serialVersionUID = 1L;

        private Renderer() {
        }

        public Object getDisplayValue(String object) {
            return object;
        }

        public String getIdValue(String object, int index) {
            return object;
        }
    }

    public static class RolePermissionsConfigSectionContributor
    extends AbstractConfigSection<Role> {
        private static final long serialVersionUID = 1L;

        @Override
        public WebMarkupContainer doCreateContents(String id, IModel<Role> input, Preferences config) {
            return new RolePermissionsConfigSection(id, input);
        }

        @Override
        public void commit(IModel<Role> input, Preferences config) {
        }

        @Override
        public String getRequiredPermission() {
            return "User:*:config";
        }
    }
}

