/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.pages;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.http.flow.AbortWithHttpErrorCodeException;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.common.util.URI;
import org.jabylon.common.resolver.URIResolver;
import org.jabylon.rest.ui.model.EObjectModel;
import org.jabylon.rest.ui.model.IEObjectModel;
import org.jabylon.rest.ui.wicket.pages.GenericPage;

public class GenericResolvablePage<T extends CDOObject>
extends GenericPage<T> {
    private static final long serialVersionUID = 1L;
    @Inject
    private URIResolver lookup;

    public GenericResolvablePage(PageParameters parameters) {
        super(parameters);
    }

    @Override
    public void setModel(IEObjectModel<T> model) {
        super.setModel(model);
    }

    @Override
    protected IEObjectModel<T> createModel(T object) {
        return new EObjectModel<T>(object);
    }

    @Override
    public IEObjectModel<T> getModel() {
        return (IEObjectModel)super.getModel();
    }

    @Override
    protected void preConstruct() {
        CDOObject modelObject = (CDOObject)this.getModelObject();
        if (modelObject == null) {
            throw new AbortWithHttpErrorCodeException(404, "Path does not exist " + this.getPageParameters());
        }
    }

    @Override
    protected IModel<T> createModel(PageParameters params) {
        T result = this.resolveModel(params);
        if (result == null) {
            throw new AbortWithHttpErrorCodeException(404, "Path does not exist " + this.getPageParameters());
        }
        return this.createModel(result);
    }

    protected T resolveModel(PageParameters params) {
        ArrayList<String> segments = new ArrayList<String>(params.getIndexedCount());
        for (StringValue value : params.getValues("segment")) {
            if (value.toString() == null || value.toString().isEmpty()) continue;
            segments.add(value.toString());
        }
        for (int i = 0; i < params.getIndexedCount(); ++i) {
            StringValue value;
            value = params.get(i);
            if (value.toString() == null || value.toString().isEmpty()) continue;
            segments.add(value.toString());
        }
        T lookup = this.doLookup(segments);
        return lookup;
    }

    protected T doLookup(List<String> segments) {
        String path = this.getURIPath(segments);
        URI uri = URI.createURI((String)path, (boolean)true);
        return (T)((CDOObject)this.lookup.resolve(uri));
    }

    private String getURIPath(List<String> segments) {
        StringBuilder builder = new StringBuilder();
        for (String string : segments) {
            builder.append(URI.encodeSegment((String)string, (boolean)true));
            builder.append("/");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        } else {
            builder.append("workspace");
        }
        return builder.toString();
    }

    public URIResolver getLookup() {
        return this.lookup;
    }
}

