/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.pages;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.http.flow.AbortWithHttpErrorCodeException;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.jabylon.index.properties.QueryService;
import org.jabylon.index.properties.SearchResult;
import org.jabylon.rest.ui.wicket.pages.GenericPage;
import org.jabylon.rest.ui.wicket.panels.SearchResultPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchPage
extends GenericPage<String> {
    public static final String MAX_HITS = "m";
    public static final String SEARCH_TERM = "t";
    public static final String SCOPE = "s";
    private static final long serialVersionUID = 1L;
    @Inject
    private QueryService queryService;
    private static final Logger logger = LoggerFactory.getLogger(SearchPage.class);

    public SearchPage(PageParameters parameters) {
        super(parameters);
        this.setStatelessHint(true);
    }

    @Override
    protected void construct() {
        super.construct();
        String term = this.getSearchTerm(this.getPageParameters());
        String scope = this.getSearchScope(this.getPageParameters());
        if (term == null) {
            this.add(new Component[]{new Label("content", (IModel)new StringResourceModel("no.term.entered.message", (Component)this, null, new Object[0]))});
        } else {
            SearchResult result = this.search(term, scope, this.getPageParameters().get(MAX_HITS).toInt(50));
            this.add(new Component[]{new SearchResultPanel("content", result, this.getPageParameters())});
        }
    }

    private SearchResult search(String term, String scope, int maxHits) {
        try {
            return this.queryService.search(term, scope);
        }
        catch (RuntimeException e) {
            throw new AbortWithHttpErrorCodeException(500, e.getMessage());
        }
    }

    private String getSearchTerm(PageParameters params) {
        StringValue value = params.get(SEARCH_TERM);
        if (value.isEmpty()) {
            return null;
        }
        return value.toString();
    }

    private String getSearchScope(PageParameters params) {
        StringValue value = params.get(SCOPE);
        if (value.isEmpty()) {
            return null;
        }
        return value.toString();
    }

    @Override
    protected IModel<String> createModel(PageParameters params) {
        StringValue value = params.get("uri");
        if (value.isEmpty()) {
            return null;
        }
        return Model.of((Serializable)((Object)value.toString()));
    }

    public boolean isBookmarkable() {
        return true;
    }
}

