/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.jabylon.rest.ui.wicket.BasicPanel;

public class BreadcrumbPanel<T>
extends BasicPanel<T> {
    private static final long serialVersionUID = 1L;
    private IModel<String> rootLabel = Model.of((Serializable)((Object)"Home"));

    public BreadcrumbPanel(String id, IModel<T> object, PageParameters parameters) {
        super(id, object, parameters);
    }

    @Override
    protected void onBeforeRenderPanel() {
        this.populateBreadcrumbs();
    }

    private void populateBreadcrumbs() {
        final List<String> segments = this.computeSegments(this.getPageParameters());
        final PageParameters crumbParams = new PageParameters();
        ListView<String> listView = new ListView<String>("crumbs", segments){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                BookmarkablePageLink link;
                if (item.getModelObject() == null || ((String)item.getModelObject()).isEmpty()) {
                    link = new BookmarkablePageLink("link", this.getPage().getClass());
                    link.setBody(BreadcrumbPanel.this.rootLabel);
                } else {
                    crumbParams.set(item.getIndex() - 1, item.getModelObject());
                    link = new BookmarkablePageLink("link", this.getPage().getClass(), new PageParameters(crumbParams));
                    link.setBody(item.getModel());
                }
                if (item.getIndex() == segments.size() - 1) {
                    link.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"active"))});
                }
                item.add(new Component[]{link});
            }
        };
        this.addOrReplace(new Component[]{listView});
    }

    private List<String> computeSegments(PageParameters pageParameters) {
        if (pageParameters == null) {
            return Collections.emptyList();
        }
        int size = pageParameters.getIndexedCount();
        ArrayList<String> segments = new ArrayList<String>(size + 1);
        segments.add("");
        for (int i = 0; i < size; ++i) {
            segments.add(pageParameters.get(i).toString());
        }
        return segments;
    }

    public void setRootLabel(IModel<String> rootLabel) {
        this.rootLabel = rootLabel;
    }

    public void setRootLabel(String rootLabel) {
        this.setRootLabel((IModel<String>)Model.of((Serializable)((Object)rootLabel)));
    }
}

