/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.repeater.Item;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.ResourceFolder;
import org.jabylon.properties.util.PropertiesSwitch;
import org.jabylon.rest.ui.util.WicketUtil;

class ImageSwitch
extends PropertiesSwitch<Item<?>> {
    private transient Item<?> item;

    public ImageSwitch(Item<?> item) {
        this.item = item;
    }

    public Item<?> caseProject(Project object) {
        return this.addCSSIcon("icon-folder-close");
    }

    public Item<?> caseProjectLocale(ProjectLocale object) {
        if (object.getLocale() == null) {
            return this.addCSSIcon("icon-book");
        }
        WebMarkupContainer markupContainer = new WebMarkupContainer("css-icon");
        this.item.add(new Component[]{markupContainer});
        markupContainer.setVisible(false);
        Image image = new Image("regular-image", WicketUtil.getIconForLocale(object.getLocale()));
        this.item.add(new Component[]{image});
        return this.item;
    }

    public Item<?> caseProjectVersion(ProjectVersion object) {
        return this.addCSSIcon("icon-time");
    }

    public Item<?> caseResourceFolder(ResourceFolder object) {
        return this.addCSSIcon("icon-folder-open");
    }

    public <P extends Resolvable<?, ?>, C extends Resolvable<?, ?>> Item<?> caseResolvable(Resolvable<P, C> object) {
        return this.addCSSIcon("icon-file");
    }

    protected Item<?> addCSSIcon(String icon) {
        WebMarkupContainer markupContainer = new WebMarkupContainer("css-icon");
        this.item.add(new Component[]{markupContainer});
        markupContainer.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)icon))});
        Image image = new Image("regular-image", "not-there.gif");
        image.setVisible(false);
        this.item.add(new Component[]{image});
        return this.item;
    }
}

