/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.jabylon.rest.ui.model.PropertyPair;
import org.jabylon.rest.ui.tools.PropertyEditorTool;
import org.jabylon.rest.ui.tools.PropertyToolTab;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ClientSideTabbedPanel;

public class PropertiesTools
extends BasicPanel<PropertyPair> {
    private static final long serialVersionUID = 1L;
    @Inject
    private List<PropertyEditorTool> tools;
    private ClientSideTabbedPanel<PropertyToolTab> tabContainer;
    private List<PropertyToolTab> extensions;

    public PropertiesTools(String id, IModel<PropertyPair> model, PageParameters pageParameters) {
        super(id, model, pageParameters);
    }

    @Override
    protected void construct() {
        this.extensions = this.createExtensions();
        this.tabContainer = new ClientSideTabbedPanel<PropertyToolTab>("tabs", this.extensions, true, "propertyTools/activeTab");
        this.add(new Component[]{this.tabContainer});
        PropertyPair pair = (PropertyPair)this.getModelObject();
        for (PropertyToolTab tool : this.extensions) {
            tool.setModel((IModel<PropertyPair>)Model.of((Serializable)pair));
        }
    }

    private List<PropertyToolTab> createExtensions() {
        ArrayList<PropertyToolTab> extensions = new ArrayList<PropertyToolTab>(this.tools.size());
        Collections.sort(this.tools, new Comparator<PropertyEditorTool>(){

            @Override
            public int compare(PropertyEditorTool o1, PropertyEditorTool o2) {
                return o1.getPrecedence() - o2.getPrecedence();
            }
        });
        for (PropertyEditorTool tool : this.tools) {
            extensions.add(new PropertyToolTab(tool));
        }
        return extensions;
    }
}

