/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Session;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.http.flow.AbortWithHttpErrorCodeException;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jabylon.cdo.connector.Modification;
import org.jabylon.cdo.connector.TransactionUtil;
import org.jabylon.common.util.URLUtil;
import org.jabylon.properties.Comment;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Review;
import org.jabylon.properties.ReviewState;
import org.jabylon.properties.Severity;
import org.jabylon.resources.persistence.PropertyPersistenceService;
import org.jabylon.rest.ui.Activator;
import org.jabylon.rest.ui.model.PropertyPair;
import org.jabylon.rest.ui.security.CDOAuthenticatedSession;
import org.jabylon.rest.ui.security.RestrictedComponent;
import org.jabylon.rest.ui.util.GlobalResources;
import org.jabylon.rest.ui.util.WebContextUrlResourceReference;
import org.jabylon.rest.ui.wicket.BasicResolvablePanel;
import org.jabylon.rest.ui.wicket.components.AnchorBookmarkablePageLink;
import org.jabylon.rest.ui.wicket.panels.PropertiesTools;
import org.jabylon.rest.ui.wicket.panels.PropertyListMode;
import org.jabylon.security.CommonPermissions;
import org.jabylon.users.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEditorSinglePanel
extends BasicResolvablePanel<PropertyFileDescriptor>
implements RestrictedComponent {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PropertyEditorSinglePanel.class);
    IModel<Multimap<String, Review>> reviewModel;
    IModel<PropertyPair> previousModel;
    IModel<PropertyPair> mainModel;
    IModel<PropertyPair> nextModel;
    EditKind editKind = EditKind.EDIT;
    private int index;
    private int total;
    private PropertyListMode mode;
    private String targetKey;

    public PropertyEditorSinglePanel(PropertyFileDescriptor object, PageParameters parameters) {
        super("content", object, parameters);
        this.mode = PropertyListMode.getByName(parameters.get("mode").toString("ALL"));
        this.targetKey = parameters.get("key").toString(null);
    }

    @Override
    protected void construct() {
        super.construct();
        this.editKind = this.computeEditKind();
        this.addLinkList(this.mode);
        this.reviewModel = new LoadableDetachableModel<Multimap<String, Review>>(){
            private static final long serialVersionUID = 1L;

            protected Multimap<String, Review> load() {
                return PropertyEditorSinglePanel.this.buildReviewMap((PropertyFileDescriptor)PropertyEditorSinglePanel.this.getModelObject());
            }
        };
        this.createModels((IModel<PropertyFileDescriptor>)this.getModel(), this.targetKey, this.mode);
    }

    private EditKind computeEditKind() {
        ProjectVersion version = (ProjectVersion)((PropertyFileDescriptor)this.getModel().getObject()).getProjectLocale().getParent();
        if (version.isReadOnly()) {
            return EditKind.READONLY;
        }
        Session session = this.getSession();
        if (session instanceof CDOAuthenticatedSession) {
            Project project = (Project)version.getParent();
            CDOAuthenticatedSession authSession = (CDOAuthenticatedSession)session;
            if (authSession.hasPermission(CommonPermissions.constructPermission((String[])new String[]{"Project", project.getName(), "edit"}))) {
                return EditKind.EDIT;
            }
            if (authSession.hasPermission(CommonPermissions.constructPermission((String[])new String[]{"Project", project.getName(), "suggest"}))) {
                return EditKind.SUGGEST;
            }
        }
        return EditKind.READONLY;
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)GlobalResources.JS_WARN_WHEN_DIRTY));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)GlobalResources.JS_SHORTCUTS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new WebContextUrlResourceReference("js/singlePropertyEditor.js")));
        super.renderHead(response);
    }

    private void createModels(IModel<PropertyFileDescriptor> model, String targetKey, PropertyListMode mode) {
        PropertyFileDescriptor descriptor = (PropertyFileDescriptor)model.getObject();
        Multimap reviews = (Multimap)this.reviewModel.getObject();
        PropertyFileDescriptor master = descriptor.getMaster();
        Map translated = PropertyEditorSinglePanel.loadProperties(descriptor).asMap();
        PropertyFile templateFile = PropertyEditorSinglePanel.loadProperties(master);
        this.total = templateFile.getProperties().size();
        PropertyPair previous = null;
        PropertyPair main = null;
        PropertyPair next = null;
        this.index = 1;
        for (Property property : templateFile.getProperties()) {
            Property translation = (Property)translated.remove(property.getKey());
            if (translation == null) {
                translation = PropertiesFactory.eINSTANCE.createProperty();
            }
            translation.setKey(property.getKey());
            PropertyPair pair = new PropertyPair((Property)EcoreUtil.copy((EObject)property), (Property)EcoreUtil.copy((EObject)translation), descriptor.getVariant(), descriptor.cdoID());
            String key = pair.getKey();
            if (mode.apply(pair, reviews.get((Object)key))) {
                if (main != null) {
                    next = pair;
                    break;
                }
                if (targetKey == null || key != null && key.equals(targetKey)) {
                    main = pair;
                } else {
                    previous = pair;
                }
            }
            if (main != null) continue;
            ++this.index;
        }
        if (next == null) {
            for (Property property : translated.values()) {
                PropertyPair pair = new PropertyPair(null, (Property)EcoreUtil.copy((EObject)property), descriptor.getVariant(), descriptor.cdoID());
                if (mode.apply(pair, reviews.get((Object)pair.getKey()))) {
                    if (main != null) {
                        next = pair;
                        break;
                    }
                    if (targetKey == null || pair.getKey() != null && pair.getKey().equals(targetKey)) {
                        main = pair;
                    } else {
                        previous = pair;
                    }
                }
                if (main != null) continue;
                ++this.index;
            }
        }
        if (previous != null) {
            this.previousModel = Model.of(previous);
        }
        if (main == null) {
            String message = "Property with key {0} was not found in mode {1}";
            message = MessageFormat.format(message, new Object[]{targetKey, mode});
            logger.info(message);
            throw new AbortWithHttpErrorCodeException(404, message);
        }
        this.mainModel = Model.of(main);
        if (next != null) {
            this.nextModel = Model.of(next);
        }
        this.buildComponentTree(previous, main, next);
    }

    private static PropertyFile loadProperties(PropertyFileDescriptor descriptor) {
        try {
            PropertyFile propertyFile = PropertyEditorSinglePanel.getPropertyPersistence().loadProperties(descriptor);
            return propertyFile;
        }
        catch (ExecutionException e) {
            logger.error("Failed to load property file for " + descriptor, (Throwable)e);
            throw new AbortWithHttpErrorCodeException(500, "Failed to load property file for " + descriptor);
        }
    }

    private static PropertyPersistenceService getPropertyPersistence() {
        return Activator.getDefault().getPersistenceService();
    }

    private void buildComponentTree(PropertyPair previous, final PropertyPair main, PropertyPair next) {
        PropertySubmitForm pairForm = new PropertySubmitForm("properties-form", (IModel<Property>)Model.of((Serializable)main.getTranslation()), this.reviewModel, this.previousModel, this.mainModel, this.nextModel, (IModel<PropertyFileDescriptor>)this.getModel(), this.editKind);
        this.add(new Component[]{pairForm});
        StringResourceModel saveLabel = this.editKind == EditKind.EDIT ? this.nls("PropertyEditorSinglePanel.save.button", new Object[0]) : this.nls("PropertyEditorSinglePanel.suggest.button", new Object[0]);
        Button saveButton = new Button("save");
        saveButton.setVisibilityAllowed(this.editKind != EditKind.READONLY);
        saveButton.add(new Component[]{new Label("label", (IModel)saveLabel)});
        pairForm.add(new Component[]{saveButton});
        Button resetButton = new Button("reset");
        resetButton.setVisibilityAllowed(this.editKind != EditKind.READONLY);
        pairForm.add(new Component[]{resetButton});
        Button nextButton = new Button("next");
        Button previousButton = new Button("previous");
        String nextButtonLabelKey = "PropertyEditorSinglePanel.next.button";
        String previousButtonLabelKey = "PropertyEditorSinglePanel.previous.button";
        switch (this.editKind) {
            case EDIT: {
                break;
            }
            case SUGGEST: {
                nextButtonLabelKey = nextButtonLabelKey + ".suggest";
                previousButtonLabelKey = previousButtonLabelKey + ".suggest";
                break;
            }
            case READONLY: {
                nextButtonLabelKey = nextButtonLabelKey + ".readonly";
                previousButtonLabelKey = previousButtonLabelKey + ".readonly";
            }
        }
        nextButton.add(new Component[]{new Label("label", (IModel)this.nls(nextButtonLabelKey, new Object[0]))});
        previousButton.add(new Component[]{new Label("label", (IModel)this.nls(previousButtonLabelKey, new Object[0]))});
        Property template = main.getTemplate();
        String key = null;
        key = template != null ? main.getTemplate().getKey() : main.getTranslation().getKey();
        Label icon = new Label("icon");
        icon.setOutputMarkupId(true);
        pairForm.add(new Component[]{icon});
        WebMarkupContainer templatePanel = new WebMarkupContainer("template-area");
        templatePanel.setOutputMarkupId(true);
        pairForm.add(new Component[]{templatePanel});
        WebMarkupContainer translationPanel = new WebMarkupContainer("translation-area");
        translationPanel.setOutputMarkupId(true);
        pairForm.add(new Component[]{translationPanel});
        Label translationLabel = new Label("translation-label", (IModel)new PropertyModel((Object)main, "translated"));
        pairForm.add(new Component[]{new Label("key-label", key)});
        pairForm.add(new Component[]{translationLabel});
        TextArea textArea = new TextArea("template", (IModel)new PropertyModel((Object)main, "original"));
        templatePanel.add(new Component[]{textArea});
        textArea.setEnabled(this.editKind != EditKind.READONLY);
        textArea = new TextArea("template-comment", (IModel)new PropertyModel((Object)main, "originalComment"));
        templatePanel.add(new Component[]{textArea});
        textArea = new TextArea("translation-comment", (IModel)new PropertyModel((Object)main, "translatedComment"));
        translationPanel.add(new Component[]{textArea});
        if (this.editKind == EditKind.READONLY) {
            textArea.add(new Behavior[]{new AttributeModifier("readonly", (Serializable)((Object)"readonly"))});
        }
        textArea = new TextArea("translation", (IModel)new PropertyModel((Object)main, "translated"));
        textArea.add(new Behavior[]{new AttributeModifier("lang", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return main.getLanguage().toString().replace('_', '-');
            }
        })});
        textArea.add(new Behavior[]{new AttributeModifier("translate", (Serializable)((Object)"no"))});
        if (this.editKind == EditKind.READONLY) {
            textArea.add(new Behavior[]{new AttributeModifier("readonly", (Serializable)((Object)"readonly"))});
        }
        translationPanel.add(new Component[]{textArea});
        pairForm.add(new Component[]{nextButton});
        pairForm.add(new Component[]{previousButton});
        String progressLabel = (String)new StringResourceModel("translation.progress", (Component)this, null, new Object[]{this.index, this.total}).getObject();
        progressLabel = MessageFormat.format(progressLabel, this.index, this.total);
        Label progress = new Label("progress", String.valueOf(progressLabel));
        double actualIndex = Math.max(1, this.index);
        int percent = (int)(actualIndex / (double)this.total * 100.0);
        progress.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)("width: " + percent + "%")))});
        pairForm.add(new Component[]{progress});
        this.fillReviewsColumn(this.mainModel, (MarkupContainer)pairForm);
        PropertiesTools tools = new PropertiesTools("tools", this.mainModel, new PageParameters());
        this.add(new Component[]{tools});
    }

    private Multimap<String, Review> buildReviewMap(PropertyFileDescriptor object) {
        EList reviews = object.getReviews();
        ArrayListMultimap reviewMap = ArrayListMultimap.create((int)reviews.size(), (int)2);
        for (Review review : reviews) {
            reviewMap.put((Object)review.getKey(), (Object)review);
        }
        return reviewMap;
    }

    private void addLinkList(final PropertyListMode currentMode) {
        List<PropertyListMode> values = Arrays.asList(PropertyListMode.values());
        ListView<PropertyListMode> mode = new ListView<PropertyListMode>("view-mode", values){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<PropertyListMode> item) {
                String mode = ((PropertyListMode)((Object)item.getModelObject())).name().toLowerCase();
                String anchor = URLUtil.escapeToIdAttribute((String)((PropertyPair)PropertyEditorSinglePanel.this.mainModel.getObject()).getKey());
                PageParameters pageParams = new PageParameters(PropertyEditorSinglePanel.this.getPageParameters()).clearNamed().set("mode", (Object)mode);
                AnchorBookmarkablePageLink link = new AnchorBookmarkablePageLink("link", this.getPage().getClass(), pageParams, anchor);
                link.setBody((IModel)new StringResourceModel(((PropertyListMode)((Object)item.getModelObject())).name(), item, null, new Object[0]));
                item.add(new Component[]{link});
                link.add(new Behavior[]{new AttributeModifier("onclick", (Serializable)((Object)"return confirmAction()"))});
                if (item.getModelObject() == currentMode) {
                    item.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"active"))});
                }
            }
        };
        this.add(new Component[]{mode});
    }

    @Override
    public String getRequiredPermission() {
        Project project = (Project)((ProjectVersion)((PropertyFileDescriptor)this.getModel().getObject()).getProjectLocale().getParent()).getParent();
        return CommonPermissions.constructPermission((String[])new String[]{"Project", project.getName(), "view"});
    }

    protected void fillReviewsColumn(IModel<PropertyPair> propertyPair, MarkupContainer container) {
        RepeatingView view = new RepeatingView("reviews");
        container.add(new Component[]{view});
        if (propertyPair == null || propertyPair.getObject() == null) {
            return;
        }
        Collection reviews = ((Multimap)this.reviewModel.getObject()).get((Object)((PropertyPair)propertyPair.getObject()).getKey());
        DateFormat formatter = SimpleDateFormat.getDateTimeInstance(3, 3, this.getSession().getLocale());
        for (Review review : reviews) {
            if (review.getState() == ReviewState.INVALID || review.getState() == ReviewState.RESOLVED) continue;
            Label label = new Label(view.newChildId(), review.getReviewType());
            label.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)this.getLabelClass(review)))});
            StringBuilder title = new StringBuilder();
            if (review.getMessage() != null) {
                title.append(review.getMessage());
            }
            if (review.getCreated() > 0L) {
                if (title.length() > 0) {
                    title.append("\n");
                }
                title.append(formatter.format(new Date(review.getCreated())));
            }
            if (title.length() > 0) {
                label.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)title.toString()))});
            }
            view.add(new Component[]{label});
        }
    }

    protected String getLabelClass(Review review) {
        Severity severity = review.getSeverity();
        switch (severity) {
            case ERROR: {
                return " label-important";
            }
            case INFO: {
                return " label-info";
            }
            case WARNING: {
                return " label-warning";
            }
        }
        return "";
    }

    private static class PropertySubmitForm
    extends StatelessForm<Property> {
        private static final long serialVersionUID = 1L;
        private IModel<Multimap<String, Review>> reviewModel;
        private IModel<PropertyPair> previousModel;
        private IModel<PropertyPair> mainModel;
        private IModel<PropertyPair> nextModel;
        private IModel<PropertyFileDescriptor> descriptorModel;
        private IModel<Boolean> modified;
        private EditKind editKind = EditKind.EDIT;

        public PropertySubmitForm(String id, IModel<Property> model, IModel<Multimap<String, Review>> reviewModel, IModel<PropertyPair> previousModel, IModel<PropertyPair> mainModel, IModel<PropertyPair> nextModel, IModel<PropertyFileDescriptor> descriptorModel, EditKind editKind) {
            super(id, model);
            this.reviewModel = reviewModel;
            this.previousModel = previousModel;
            this.mainModel = mainModel;
            this.nextModel = nextModel;
            this.descriptorModel = descriptorModel;
            this.modified = Model.of((Serializable)Boolean.valueOf(false));
            this.editKind = editKind;
            CheckBox modifiedIndicator = new CheckBox("modify-indicator", this.modified);
            modifiedIndicator.setDefaultModelObject((Object)false);
            this.add(new Component[]{modifiedIndicator});
        }

        protected void onSubmit() {
            super.onSubmit();
            this.doSubmit();
        }

        protected void doSubmit() {
            IFormSubmitter submitter = this.findSubmittingButton();
            if (submitter instanceof Button && ((Button)submitter).getId().equals("reset")) {
                this.setResponsePage(this.getPage().getClass(), this.getPageParameters().set("key", (Object)((PropertyPair)this.mainModel.getObject()).getKey()));
                return;
            }
            if (((Boolean)this.modified.getObject()).booleanValue()) {
                if (this.editKind == EditKind.EDIT) {
                    PropertyFileDescriptor descriptor = (PropertyFileDescriptor)this.descriptorModel.getObject();
                    PropertyFile file = PropertyEditorSinglePanel.loadProperties(descriptor);
                    Map map = file.asMap();
                    Property translation = (Property)this.getModelObject();
                    if (translation != null) {
                        if (map.containsKey(translation.getKey())) {
                            Property property = (Property)map.get(translation.getKey());
                            property.setComment(translation.getComment());
                            property.setValue(translation.getValue());
                        } else if (!this.isEmpty(translation.getValue())) {
                            file.getProperties().add((Object)translation);
                        }
                    }
                    PropertyEditorSinglePanel.getPropertyPersistence().saveProperties(descriptor, file);
                    if (translation.getValue() != null) {
                        Multimap reviewMap = (Multimap)this.reviewModel.getObject();
                        Collection reviews = reviewMap.get((Object)translation.getKey());
                        for (Review review : reviews) {
                            if (review.getState() != ReviewState.OPEN || !"Suggestion".equals(review.getReviewType()) || !translation.getValue().equals(review.getMessage())) continue;
                            try {
                                TransactionUtil.commit((EObject)review, (Modification)new Modification<Review, Review>(){

                                    public Review apply(Review object) {
                                        object.setState(ReviewState.RESOLVED);
                                        return object;
                                    }
                                });
                            }
                            catch (CommitException e) {
                                logger.error("Failed to commit review resolution", (Throwable)e);
                            }
                        }
                    }
                } else if (this.editKind == EditKind.SUGGEST) {
                    CDOAuthenticatedSession authSession;
                    User user;
                    Property translation = (Property)this.getModelObject();
                    PropertyFileDescriptor descriptor = (PropertyFileDescriptor)this.descriptorModel.getObject();
                    final Review review = PropertiesFactory.eINSTANCE.createReview();
                    review.setCreated(System.currentTimeMillis());
                    review.setKey(translation.getKey());
                    review.setMessage(translation.getValue());
                    review.setSeverity(Severity.INFO);
                    review.setReviewType("Suggestion");
                    String username = "Anonymous";
                    Session session = this.getSession();
                    if (session instanceof CDOAuthenticatedSession && (user = (authSession = (CDOAuthenticatedSession)session).getUser()) != null) {
                        username = user.getName();
                    }
                    review.setUser(username);
                    if (translation.getComment() != null && !translation.getComment().isEmpty()) {
                        Comment comment = PropertiesFactory.eINSTANCE.createComment();
                        comment.setUser(username);
                        comment.setCreated(review.getCreated());
                        comment.setMessage(translation.getComment());
                        review.getComments().add((Object)comment);
                    }
                    try {
                        TransactionUtil.commit((EObject)descriptor, (Modification)new Modification<PropertyFileDescriptor, PropertyFileDescriptor>(){

                            public PropertyFileDescriptor apply(PropertyFileDescriptor object) {
                                object.getReviews().add((Object)review);
                                return object;
                            }
                        });
                    }
                    catch (CommitException e) {
                        logger.error("Commit of suggestion failed", (Throwable)e);
                    }
                }
            }
            if (submitter instanceof Button) {
                Button button = (Button)submitter;
                if (button.getId().equals("next")) {
                    if (this.nextModel != null && this.nextModel.getObject() != null) {
                        this.setResponsePage(this.getPage().getClass(), this.getPageParameters().set("key", (Object)((PropertyPair)this.nextModel.getObject()).getKey()));
                    } else {
                        this.setResponsePage(this.getPage().getClass(), this.getPageParameters().set("key", null));
                    }
                } else if (button.getId().equals("previous")) {
                    if (this.previousModel != null && this.previousModel.getObject() != null) {
                        this.setResponsePage(this.getPage().getClass(), this.getPageParameters().set("key", (Object)((PropertyPair)this.previousModel.getObject()).getKey()));
                    } else {
                        this.setResponsePage(this.getPage().getClass(), this.getPageParameters().set("key", null));
                    }
                } else {
                    this.setResponsePage(this.getPage().getClass(), this.getPageParameters().set("key", (Object)((PropertyPair)this.mainModel.getObject()).getKey()));
                }
            }
        }

        private PageParameters getPageParameters() {
            return this.getPage().getPageParameters();
        }

        private boolean isEmpty(String string) {
            return string == null || string.isEmpty();
        }
    }

    private static enum EditKind {
        READONLY,
        SUGGEST,
        EDIT;

    }
}

