/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.http.flow.AbortWithHttpErrorCodeException;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.jabylon.common.util.URLUtil;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Review;
import org.jabylon.properties.ReviewState;
import org.jabylon.properties.Severity;
import org.jabylon.resources.persistence.PropertyPersistenceService;
import org.jabylon.rest.ui.model.EClassSortState;
import org.jabylon.rest.ui.model.EObjectModel;
import org.jabylon.rest.ui.model.PropertyPair;
import org.jabylon.rest.ui.util.WicketUtil;
import org.jabylon.rest.ui.wicket.BasicResolvablePanel;
import org.jabylon.rest.ui.wicket.panels.PropertyListMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyListPanel
extends BasicResolvablePanel<PropertyFileDescriptor> {
    private static final long serialVersionUID = 1L;
    IModel<Multimap<String, Review>> reviewModel;
    static final String OK_LABEL = "OK";
    private static final Logger logger = LoggerFactory.getLogger(PropertyPairListDataProvider.class);
    @Inject
    private PropertyPersistenceService propertyPersistence;
    private PropertyListMode mode;

    public PropertyListPanel(PropertyFileDescriptor object, PageParameters parameters) {
        super("content", object, parameters);
        this.mode = PropertyListMode.getByName(parameters.get("mode").toString("ALL"));
    }

    @Override
    protected void construct() {
        super.construct();
        this.addLinkList(this.mode);
        this.reviewModel = new LoadableDetachableModel<Multimap<String, Review>>(){
            private static final long serialVersionUID = 1L;

            protected Multimap<String, Review> load() {
                return PropertyListPanel.this.buildReviewMap((PropertyFileDescriptor)PropertyListPanel.this.getModelObject());
            }
        };
        PropertyPairListDataProvider provider = new PropertyPairListDataProvider((PropertyFileDescriptor)this.getModelObject(), this.mode, this.reviewModel);
        List<PropertyPair> contents = provider.createContents();
        ListView<PropertyPair> properties = new ListView<PropertyPair>("repeater", contents){
            private static final long serialVersionUID = -7087485011138279358L;

            protected void populateItem(ListItem<PropertyPair> item) {
                IModel model = item.getModel();
                String key = ((PropertyPair)model.getObject()).getKey();
                Collection reviewList = ((Multimap)PropertyListPanel.this.reviewModel.getObject()).get((Object)key);
                BookmarkablePageLink link = new BookmarkablePageLink("edit", this.getPage().getClass(), new PageParameters(PropertyListPanel.this.getPageParameters()).add("key", (Object)key));
                item.add(new Component[]{link});
                link.setMarkupId(URLUtil.escapeToIdAttribute((String)key));
                link.setOutputMarkupId(true);
                link.add(new Behavior[]{new AttributeModifier("name", (Serializable)((Object)link.getMarkupId()))});
                Label keyLabel = new Label("key", key);
                keyLabel.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)((PropertyPair)model.getObject()).getTranslated()))});
                item.add(new Component[]{keyLabel});
                Label translationLabel = new Label("translation", ((PropertyPair)model.getObject()).getTranslated());
                translationLabel.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)((PropertyPair)model.getObject()).getTranslatedComment()))});
                item.add(new Component[]{translationLabel});
                PropertyListPanel.this.fillStatusColumn((PropertyPair)model.getObject(), reviewList, (MarkupContainer)item);
            }
        };
        properties.setOutputMarkupId(true);
        this.add(new Component[]{properties});
        String contextPath = WicketUtil.getContextPath();
        String href = contextPath + "/api" + ((PropertyFileDescriptor)this.getModelObject()).toURI().appendQuery("type=file");
        ExternalLink link = new ExternalLink("download.link", href);
        File file = new File(((PropertyFileDescriptor)this.getModelObject()).absoluteFilePath().toFileString());
        boolean enabled = file.isFile();
        link.setEnabled(enabled);
        if (!enabled) {
            link.add(new Behavior[]{new AttributeAppender("disabled", (IModel)Model.of((Serializable)((Object)"disabled")))});
            link.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"disabled")))});
        }
        this.add(new Component[]{link});
    }

    protected void fillStatusColumn(PropertyPair propertyPair, Collection<Review> reviewCollection, MarkupContainer container) {
        IStatus status = this.calculateRowStatus(propertyPair);
        if (status.getSeverity() == 2) {
            container.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"warning"))});
        } else if (status.getSeverity() == 4) {
            container.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"error"))});
        }
        Collection<Review> reviews = reviewCollection;
        if (reviews == null || reviews.isEmpty()) {
            reviews = this.createInMemoryReview(propertyPair);
        }
        RepeatingView view = new RepeatingView("reviews");
        DateFormat formatter = SimpleDateFormat.getDateTimeInstance(3, 3, this.getSession().getLocale());
        for (Review review : reviews) {
            if (review.getState() == ReviewState.INVALID || review.getState() == ReviewState.RESOLVED) continue;
            Label label = new Label(view.newChildId(), review.getReviewType());
            label.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)this.getLabelClass(review)))});
            StringBuilder title = new StringBuilder();
            if (review.getMessage() != null) {
                title.append(review.getMessage());
            }
            if (review.getCreated() > 0L) {
                if (title.length() > 0) {
                    title.append("\n");
                }
                title.append(formatter.format(new Date(review.getCreated())));
            }
            if (title.length() > 0) {
                label.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)title.toString()))});
            }
            view.add(new Component[]{label});
        }
        container.add(new Component[]{view});
    }

    private IStatus calculateRowStatus(PropertyPair propertyPair) {
        if (propertyPair.getOriginal() == null || propertyPair.getOriginal().isEmpty()) {
            return new Status(4, "org.jabylon.rest.ui", "");
        }
        if (propertyPair.getTranslated() == null || propertyPair.getTranslated().isEmpty()) {
            return new Status(4, "org.jabylon.rest.ui", "");
        }
        return Status.OK_STATUS;
    }

    private List<Review> createInMemoryReview(PropertyPair pair) {
        if (pair.getTranslated() == null || pair.getTranslated().isEmpty()) {
            Review review = PropertiesFactory.eINSTANCE.createReview();
            String message = new StringResourceModel("review.missing.translation", (Component)this, null, pair.getKey(), new Object[0]).getString();
            review.setMessage(MessageFormat.format(message, pair.getKey()));
            review.setReviewType(this.getString("review.missing.translation.type"));
            review.setSeverity(Severity.ERROR);
            return Collections.singletonList(review);
        }
        Review review = PropertiesFactory.eINSTANCE.createReview();
        review.setReviewType(OK_LABEL);
        return Collections.singletonList(review);
    }

    protected String getLabelClass(Review review) {
        if (OK_LABEL.equals(review.getReviewType())) {
            return " label-success";
        }
        Severity severity = review.getSeverity();
        switch (severity) {
            case ERROR: {
                return " label-important";
            }
            case INFO: {
                return " label-info";
            }
            case WARNING: {
                return " label-warning";
            }
        }
        return "";
    }

    private Multimap<String, Review> buildReviewMap(PropertyFileDescriptor object) {
        EList reviews = object.getReviews();
        ArrayListMultimap reviewMap = ArrayListMultimap.create((int)reviews.size(), (int)2);
        for (Review review : reviews) {
            if (review.getState() != ReviewState.OPEN && review.getState() != ReviewState.REOPENED) continue;
            reviewMap.put((Object)review.getKey(), (Object)review);
        }
        return reviewMap;
    }

    private void addLinkList(final PropertyListMode currentMode) {
        List<PropertyListMode> values = Arrays.asList(PropertyListMode.values());
        ListView<PropertyListMode> mode = new ListView<PropertyListMode>("view-mode", values){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<PropertyListMode> item) {
                String mode = ((PropertyListMode)((Object)item.getModelObject())).name().toLowerCase();
                BookmarkablePageLink link = new BookmarkablePageLink("link", this.getPage().getClass(), new PageParameters(PropertyListPanel.this.getPageParameters()).set("mode", (Object)mode));
                link.setBody((IModel)new StringResourceModel(((PropertyListMode)((Object)item.getModelObject())).name(), item, null, new Object[0]));
                item.add(new Component[]{link});
                if (item.getModelObject() == currentMode) {
                    item.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"active"))});
                }
            }
        };
        this.add(new Component[]{mode});
    }

    class PropertyPairListDataProvider
    extends SortableDataProvider<PropertyPair, EClassSortState>
    implements IFilterStateLocator<String> {
        private static final long serialVersionUID = 1L;
        private CompoundPropertyModel<PropertyFileDescriptor> model;
        private transient List<PropertyPair> contents;
        private String filterState;
        private PropertyListMode mode;
        private IModel<Multimap<String, Review>> reviewModel;

        public PropertyPairListDataProvider(PropertyFileDescriptor descriptor, PropertyListMode mode, IModel<Multimap<String, Review>> reviewModel) {
            this.model = new CompoundPropertyModel(new EObjectModel<PropertyFileDescriptor>(descriptor));
            this.mode = mode;
            this.reviewModel = reviewModel;
        }

        public Iterator<? extends PropertyPair> iterator(long first, long count) {
            List<PropertyPair> contents = this.getList();
            return contents.subList((int)first, (int)first + (int)count).iterator();
        }

        private List<PropertyPair> getList() {
            if (this.contents == null) {
                this.contents = this.createContents();
            }
            return this.contents;
        }

        protected List<PropertyPair> createContents() {
            PropertyPair pair;
            PropertyFileDescriptor descriptor = (PropertyFileDescriptor)this.model.getObject();
            Multimap reviews = (Multimap)this.reviewModel.getObject();
            PropertyFileDescriptor master = descriptor.getMaster();
            Map translated = this.loadProperties(descriptor).asMap();
            PropertyFile templateFile = this.loadProperties(master);
            ArrayList<PropertyPair> contents = new ArrayList<PropertyPair>();
            for (Property property : templateFile.getProperties()) {
                String key;
                pair = new PropertyPair(property, (Property)translated.remove(property.getKey()), descriptor.getVariant(), descriptor.cdoID());
                if (!this.mode.apply(pair, reviews.get((Object)(key = pair.getKey())))) continue;
                contents.add(pair);
            }
            for (Property property : translated.values()) {
                pair = new PropertyPair(null, property, descriptor.getVariant(), descriptor.cdoID());
                if (!this.mode.apply(pair, reviews.get((Object)pair.getKey()))) continue;
                contents.add(pair);
            }
            return contents;
        }

        private PropertyFile loadProperties(PropertyFileDescriptor descriptor) {
            try {
                return PropertyListPanel.this.propertyPersistence.loadProperties(descriptor);
            }
            catch (ExecutionException e) {
                logger.error("Failed to load properties for " + descriptor);
                throw new AbortWithHttpErrorCodeException(500, "Failed to load properties for " + descriptor);
            }
        }

        public long size() {
            return this.getList().size();
        }

        public IModel<PropertyPair> model(PropertyPair object) {
            return Model.of((Serializable)object);
        }

        public void setFilterState(String state) {
            this.filterState = state;
        }

        public String getFilterState() {
            return this.filterState;
        }
    }
}

