/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.validators;

import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.eclipse.emf.common.util.EList;
import org.jabylon.properties.Project;
import org.jabylon.properties.Workspace;
import org.jabylon.rest.ui.model.AttachableModel;

public class TerminologyProjectValidator
implements IValidator<Boolean> {
    private static final long serialVersionUID = 1L;
    private IModel<Project> project;

    public TerminologyProjectValidator(IModel<Project> project) {
        this.project = project;
    }

    public void validate(IValidatable<Boolean> validatable) {
        if (((Boolean)validatable.getValue()).booleanValue()) {
            Project object = (Project)this.project.getObject();
            Workspace workspace = (Workspace)object.getParent();
            if (workspace == null && this.project instanceof AttachableModel) {
                AttachableModel model = (AttachableModel)this.project;
                workspace = (Workspace)model.getParent().getObject();
            }
            if (workspace != null) {
                EList children = workspace.getChildren();
                for (Project other : children) {
                    if (other == object || !other.isTerminology()) continue;
                    ValidationError error = new ValidationError((IValidator)this);
                    error.getVariables().put("name", other.getName());
                    validatable.error((IValidationError)error);
                }
            }
        }
    }
}

