/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.validators;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class UniqueNameValidator
implements IValidator<String> {
    private static final long serialVersionUID = 1L;
    private Set<String> usedNames;

    public UniqueNameValidator(Set<String> usedNames) {
        this.usedNames = usedNames;
    }

    public static <F> UniqueNameValidator fromCollection(Collection<F> objects, Function<F, String> nameExtractor, F exclude) {
        HashSet<String> names = new HashSet<String>();
        for (F f : objects) {
            if (f.equals(exclude)) continue;
            names.add((String)nameExtractor.apply(f));
        }
        return new UniqueNameValidator(names);
    }

    public static <F extends EObject> UniqueNameValidator fromCollection(Collection<F> objects, EStructuralFeature feature, F exclude) {
        return UniqueNameValidator.fromCollection(objects, new EGetFunction(feature), exclude);
    }

    public void validate(IValidatable<String> validatable) {
        if (this.usedNames.contains(validatable.getValue())) {
            ValidationError error = new ValidationError((IValidator)this);
            error.getVariables().put("name", validatable.getValue());
            validatable.error((IValidationError)error);
        }
    }

    private static class EGetFunction<F extends EObject>
    implements Function<F, String> {
        private EStructuralFeature feature;

        public EGetFunction(EStructuralFeature feature) {
            this.feature = feature;
        }

        public String apply(F input) {
            return (String)input.eGet(this.feature);
        }
    }
}

