/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.review.standard.cleanup;

import java.util.Iterator;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Workspace;
import org.jabylon.resources.persistence.PropertyPersistenceService;
import org.jabylon.review.standard.ReviewActivator;
import org.jabylon.scheduler.JobExecution;
import org.jabylon.scheduler.JobUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(enabled=true, immediate=true)
@Service
public class TranslationCleanupJob
implements JobExecution {
    private static final Logger logger = LoggerFactory.getLogger(TranslationCleanupJob.class);
    @Property(value={"false"}, name="active")
    private String ACTIVE = "active";
    @Property(value={"0 2 0 * * ?"}, name="schedule")
    private String DEFAULT_SCHEDULE = "schedule";
    @Property(value={"%cleanup.job.name"}, name="name")
    private String NAME = "name";
    @Property(value={"%cleanup.job.description"}, name="description")
    private String DESCRIPTION = "description";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor, Map<String, Object> jobContext) throws Exception {
        logger.info("Starting translation cleanup job");
        try (CDOView view = JobUtil.openView(jobContext);){
            CDOResource resource = view.getResource("workspace");
            Workspace workspace = (Workspace)resource.getContents().get(0);
            this.cleanup(workspace);
            logger.info("Translation cleanup job finished successfully");
        }
    }

    private void cleanup(Workspace workspace) {
        EList projects = workspace.getChildren();
        for (Project project : projects) {
            this.cleanup(project);
        }
    }

    private void cleanup(Project project) {
        for (ProjectVersion version : project.getChildren()) {
            this.cleanup(version);
        }
    }

    private void cleanup(ProjectVersion version) {
        for (ProjectLocale locale : version.getChildren()) {
            this.cleanup(locale);
        }
    }

    private void cleanup(ProjectLocale locale) {
        for (PropertyFileDescriptor descriptor : locale.getDescriptors()) {
            this.cleanup(descriptor);
        }
    }

    private void cleanup(PropertyFileDescriptor descriptor) {
        PropertyPersistenceService persistenceService = ReviewActivator.getDefault().getPersistenceService();
        try {
            PropertyFile masterProperties = persistenceService.loadProperties(descriptor.getMaster());
            Map map = masterProperties.asMap();
            PropertyFile properties = descriptor.loadProperties();
            Iterator iterator = properties.getProperties().iterator();
            boolean hadDeletes = false;
            while (iterator.hasNext()) {
                org.jabylon.properties.Property property = (org.jabylon.properties.Property)iterator.next();
                if (map.containsKey(property.getKey())) continue;
                iterator.remove();
                logger.info("Removed unused translation {} in {}", (Object)property.getKey(), (Object)descriptor.fullPath());
                hadDeletes = true;
            }
            if (hadDeletes) {
                PropertyPersistenceService propertyPersistenceService = ReviewActivator.getDefault().getPersistenceService();
                propertyPersistenceService.saveProperties(descriptor, properties);
            }
        }
        catch (Exception e) {
            logger.error("Translation cleanup failed for property " + descriptor.getLocation(), (Throwable)e);
        }
    }

    public boolean retryOnError() {
        return false;
    }

    public String getID() {
        return "job.translation.cleanup";
    }
}

