/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.review.standard.internal;

import java.text.MessageFormat;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.jabylon.common.review.ReviewParticipant;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Review;
import org.jabylon.properties.Severity;

@Component
@Service
public class PunctuationCheck
implements ReviewParticipant {
    private static char[] hotchars = new char[]{'(', ')', '[', ']', '{', '}', '\'', '\"'};

    public Review review(PropertyFileDescriptor descriptor, Property master, Property slave) {
        if (master == null || slave == null || slave.getValue() == null || slave.getValue().isEmpty()) {
            return null;
        }
        short[] templateOccurrences = new short[hotchars.length];
        String value = master.getValue();
        String translation = slave.getValue();
        this.countHotChars(value, templateOccurrences);
        this.subtractHotChars(translation, templateOccurrences);
        for (int i = 0; i < hotchars.length; ++i) {
            short occ = templateOccurrences[i];
            if (occ == 0) continue;
            Review review = PropertiesFactory.eINSTANCE.createReview();
            review.setCreated(System.currentTimeMillis());
            String message = occ < 0 ? "Translation contains more ''{0}'' characters than the template." : "Translation contains less ''{0}'' characters than the template.";
            message = MessageFormat.format(message, Character.valueOf(hotchars[i]));
            review.setMessage(message);
            review.setReviewType(this.getReviewType());
            review.setSeverity(Severity.WARNING);
            review.setUser("Jabylon");
            return review;
        }
        return null;
    }

    public String getReviewType() {
        return "Punctuation Check";
    }

    private void countHotChars(String value, short[] templateOccurrences) {
        char[] chars;
        if (value == null) {
            return;
        }
        block9: for (char c : chars = value.toCharArray()) {
            switch (c) {
                case '(': {
                    templateOccurrences[0] = (short)(templateOccurrences[0] + 1);
                    continue block9;
                }
                case ')': {
                    templateOccurrences[1] = (short)(templateOccurrences[1] + 1);
                    continue block9;
                }
                case '[': {
                    templateOccurrences[2] = (short)(templateOccurrences[2] + 1);
                    continue block9;
                }
                case ']': {
                    templateOccurrences[3] = (short)(templateOccurrences[3] + 1);
                    continue block9;
                }
                case '{': {
                    templateOccurrences[4] = (short)(templateOccurrences[4] + 1);
                    continue block9;
                }
                case '}': {
                    templateOccurrences[5] = (short)(templateOccurrences[5] + 1);
                    continue block9;
                }
                case '\"': {
                    templateOccurrences[6] = (short)(templateOccurrences[6] + 1);
                    continue block9;
                }
            }
        }
    }

    private void subtractHotChars(String value, short[] templateOccurrences) {
        char[] chars;
        if (value == null) {
            return;
        }
        block9: for (char c : chars = value.toCharArray()) {
            switch (c) {
                case '(': {
                    templateOccurrences[0] = (short)(templateOccurrences[0] - 1);
                    continue block9;
                }
                case ')': {
                    templateOccurrences[1] = (short)(templateOccurrences[1] - 1);
                    continue block9;
                }
                case '[': {
                    templateOccurrences[2] = (short)(templateOccurrences[2] - 1);
                    continue block9;
                }
                case ']': {
                    templateOccurrences[3] = (short)(templateOccurrences[3] - 1);
                    continue block9;
                }
                case '{': {
                    templateOccurrences[4] = (short)(templateOccurrences[4] - 1);
                    continue block9;
                }
                case '}': {
                    templateOccurrences[5] = (short)(templateOccurrences[5] - 1);
                    continue block9;
                }
                case '\"': {
                    templateOccurrences[6] = (short)(templateOccurrences[6] - 1);
                    continue block9;
                }
            }
        }
    }

    public String getID() {
        return "PunctuationCheck";
    }

    public String getDescription() {
        return "%punctuation.check.description";
    }

    public String getName() {
        return "%punctuation.check.name";
    }
}

