/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.review.standard.internal;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.jabylon.common.review.ReviewParticipant;
import org.jabylon.common.review.TerminologyProvider;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Review;
import org.jabylon.properties.ReviewState;
import org.jabylon.properties.Severity;

@Component
@Service(value={ReviewParticipant.class})
public class TerminologyCheck
extends AdapterImpl
implements ReviewParticipant {
    private static final String TERMINOLOGY_DELIMITER = " \t\n\r\f.,;:(){}\"'<>?-";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private TerminologyProvider terminologyProvider;

    public Review review(PropertyFileDescriptor descriptor, Property master, Property slave) {
        Locale variant = descriptor.getVariant();
        if (variant == null) {
            return null;
        }
        Map terminology = this.terminologyProvider.getTerminology(variant);
        return this.analyze(master, slave, terminology);
    }

    private Review analyze(Property master, Property slave, Map<String, Property> terminology) {
        String token;
        if (master == null || slave == null || terminology.isEmpty()) {
            return null;
        }
        String masterValue = master.getValue();
        String slaveValue = slave.getValue();
        if (masterValue == null || slaveValue == null) {
            return null;
        }
        HashMap<String, String> mustFinds = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(masterValue, TERMINOLOGY_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            Property property = terminology.get(token);
            if (property == null) continue;
            mustFinds.put(property.getValue(), property.getKey());
        }
        if (!mustFinds.isEmpty()) {
            tokenizer = new StringTokenizer(slaveValue, TERMINOLOGY_DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                mustFinds.remove(token);
            }
        }
        if (!mustFinds.isEmpty()) {
            Map.Entry next = mustFinds.entrySet().iterator().next();
            Review review = PropertiesFactory.eINSTANCE.createReview();
            review.setCreated(System.currentTimeMillis());
            review.setState(ReviewState.OPEN);
            review.setSeverity(Severity.ERROR);
            review.setReviewType(this.getReviewType());
            String message = "Template language contained the term ''{0}'' but the terminology translation ''{1}'' is missing";
            message = MessageFormat.format(message, next.getValue(), next.getKey());
            review.setMessage(message);
            return review;
        }
        return null;
    }

    public String getReviewType() {
        return "Terminology";
    }

    public void bindTerminologyProvider(TerminologyProvider provider) {
        this.terminologyProvider = provider;
    }

    public void unbindTerminologyProvider(TerminologyProvider provider) {
        if (this.terminologyProvider == provider) {
            this.terminologyProvider = null;
        }
    }

    public String getID() {
        return "TerminologyCheck";
    }

    public String getDescription() {
        return "%terminology.check.description";
    }

    public String getName() {
        return "%terminology.check.name";
    }
}

