/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.scheduler.internal.jobs;

import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.EObject;
import org.jabylon.common.team.TeamProvider;
import org.jabylon.common.team.TeamProviderException;
import org.jabylon.common.team.TeamProviderUtil;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.scheduler.JobExecution;
import org.jabylon.scheduler.JobUtil;
import org.jabylon.scheduler.internal.jobs.TeamUpdateJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(enabled=true, immediate=true)
@Service
public class TeamCommitJob
implements JobExecution {
    public static final String JOB_ID = "job.team.commit";
    private static final Logger logger = LoggerFactory.getLogger(TeamUpdateJob.class);
    @Property(value={"false"}, name="active")
    private String ACTIVE = "active";
    @Property(value={"0 5 * * * ?"}, name="schedule")
    public static final String DEFAULT_SCHEDULE = "0 5 * * * ?";
    @Property(value={"%commit.job.name"}, name="name")
    private String NAME = "name";
    @Property(value={"%commit.job.description"}, name="description")
    private String DESCRIPTION = "description";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(IProgressMonitor monitor, Map<String, Object> jobContext) throws Exception {
        ProjectVersion version = (ProjectVersion)JobUtil.getDomainObject(jobContext);
        TeamProvider provider = TeamProviderUtil.getTeamProvider((String)((Project)version.getParent()).getTeamProvider());
        CDOTransaction transaction = JobUtil.openTransaction(jobContext);
        try {
            version = (ProjectVersion)transaction.getObject((EObject)version);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Committing", (int)100);
            provider.commit(version, (IProgressMonitor)subMonitor.newChild(100));
        }
        catch (TeamProviderException e) {
            logger.error("Commit failed", (Throwable)e);
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public boolean retryOnError() {
        return false;
    }

    @Override
    public String getID() {
        return JOB_ID;
    }
}

