/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.scheduler.internal.jobs;

import java.util.Collection;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.ecore.EObject;
import org.jabylon.common.team.TeamProvider;
import org.jabylon.common.team.TeamProviderException;
import org.jabylon.common.team.TeamProviderUtil;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertyFileDiff;
import org.jabylon.resources.persistence.PropertyPersistenceService;
import org.jabylon.scheduler.JobExecution;
import org.jabylon.scheduler.JobUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(enabled=true, immediate=true)
@Service
public class TeamUpdateJob
implements JobExecution {
    public static final String JOB_ID = "job.team.update";
    private static final Logger logger = LoggerFactory.getLogger(TeamUpdateJob.class);
    @Property(value={"false"}, name="active")
    private String ACTIVE = "active";
    @Property(value={"0 0 * * * ?"}, name="schedule")
    public static final String DEFAULT_SCHEDULE = "0 0 * * * ?";
    @Property(value={"%update.job.name"}, name="name")
    private String NAME = "name";
    @Property(value={"%update.job.description"}, name="description")
    private String DESCRIPTION = "description";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private PropertyPersistenceService persistenceService;

    public void bindPersistenceService(PropertyPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void unbindPersistenceService(PropertyPersistenceService persistenceService) {
        if (persistenceService == this.persistenceService) {
            persistenceService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(IProgressMonitor monitor, Map<String, Object> jobContext) throws Exception {
        ProjectVersion version = (ProjectVersion)JobUtil.getDomainObject(jobContext);
        TeamProvider provider = TeamProviderUtil.getTeamProvider((String)((Project)version.getParent()).getTeamProvider());
        if (provider == null) {
            logger.error("Team Provider " + ((Project)version.getParent()).getTeamProvider() + " was not available. Update canceled");
            return;
        }
        CDOTransaction transaction = JobUtil.openTransaction(jobContext);
        try {
            version = (ProjectVersion)transaction.getObject((EObject)version);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Updating", (int)100);
            Collection updates = provider.update(version, (IProgressMonitor)subMonitor.newChild(50));
            subMonitor.setWorkRemaining(updates.size() * 2);
            subMonitor.subTask("Processing updates");
            for (PropertyFileDiff updatedFile : updates) {
                version.partialScan(PreferencesUtil.getScanConfigForProject((Project)((Project)version.getParent())), updatedFile);
                subMonitor.worked(1);
            }
            subMonitor.setTaskName("Database Sync");
            transaction.commit((IProgressMonitor)subMonitor.newChild(updates.size()));
        }
        catch (TeamProviderException e) {
            logger.error("Update failed", (Throwable)e);
        }
        catch (CommitException e) {
            logger.error("Failed to commit the transaction", (Throwable)e);
        }
        finally {
            transaction.close();
            if (this.persistenceService != null) {
                this.persistenceService.clearCache();
            } else {
                logger.error("Could not obtain property persistence service");
            }
        }
    }

    @Override
    public boolean retryOnError() {
        return false;
    }

    @Override
    public String getID() {
        return JOB_ID;
    }
}

