/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.team.cvs.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jabylon.common.team.TeamProvider;
import org.jabylon.common.team.TeamProviderException;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.PropertyFileDiff;
import org.jabylon.team.cvs.impl.CVSFileFilter;
import org.jabylon.team.cvs.impl.DiffListener;
import org.jabylon.team.cvs.impl.ProgressMonitorListener;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionFactory;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.Scrambler;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(enabled=true, immediate=true)
@Service
public class CVSTeamProvider
implements TeamProvider {
    private static final Logger logger = LoggerFactory.getLogger(CVSTeamProvider.class);
    @Property(value={"CVS"})
    private static String KEY_KIND = "kind";

    public void checkout(ProjectVersion project, IProgressMonitor monitor) {
        Client client = null;
        try {
            Client theClient;
            this.checkDirectories(project);
            client = theClient = this.createClient(project);
            String fullPath = project.absolutPath().toFileString();
            monitor.beginTask("Checkout", -1);
            CheckoutCommand checkout = new CheckoutCommand();
            client.getEventManager().addCVSListener((CVSListener)new ProgressMonitorListener(monitor, client, fullPath));
            String module = PreferencesUtil.scopeFor((Object)project.getParent()).get("cvs.module", "");
            checkout.setModule(module);
            checkout.setPruneDirectories(true);
            checkout.setNotShortenPaths(false);
            checkout.setCheckoutByRevision(project.getName());
            checkout.setCheckoutDirectory(project.getName());
            client.executeCommand((Command)checkout, this.getGlobalOptions((Project)project.getParent()));
        }
        catch (Exception e) {
            this.cleanupProjectVersionDirectory(project);
            throw new TeamProviderException("Checkout failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                try {
                    client.getConnection().close();
                }
                catch (IOException e) {
                    logger.error("Failed to close client connection", (Throwable)e);
                }
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void cleanupProjectVersionDirectory(ProjectVersion project) {
        File versionDir = new File(project.absolutPath().toFileString());
        try {
            versionDir.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkDirectories(ProjectVersion projectVersion) {
        File projectDir = new File(((Project)projectVersion.getParent()).absoluteFilePath().toFileString());
        if (!projectDir.exists() && !projectDir.mkdirs()) {
            throw new TeamProviderException("Checkout failed. Unable to create project directory");
        }
    }

    public void commit(ProjectVersion project, IProgressMonitor monitor) {
        Client client = null;
        try {
            Client theClient;
            client = theClient = this.createClient(project);
            String fullPath = project.absolutPath().toFileString();
            monitor.beginTask("Committing Changes", -1);
            client.getEventManager().addCVSListener((CVSListener)new ProgressMonitorListener(monitor, client, fullPath));
            File[] filesToAdd = this.calculateMissingFiles(client, new File(fullPath));
            if (filesToAdd.length > 0) {
                AddCommand add = new AddCommand();
                add.setMessage("Jabylon Auto-Sync Up");
                add.setFiles(filesToAdd);
                client.executeCommand((Command)add, this.getGlobalOptions((Project)project.getParent()));
                try {
                    client.getConnection().close();
                }
                catch (IOException e) {
                    logger.error("Failed to close client connection", (Throwable)e);
                }
                client = theClient = this.createClient(project);
            }
            CommitCommand commit = new CommitCommand();
            commit.setRecursive(true);
            commit.setMessage("Jabylon Auto-Sync Up");
            commit.setFiles(new File(fullPath).listFiles(new CVSFileFilter()));
            client.executeCommand((Command)commit, this.getGlobalOptions((Project)project.getParent()));
        }
        catch (AuthenticationException e) {
            throw new TeamProviderException("Commit failed", (Throwable)e);
        }
        catch (CommandAbortedException e) {
            throw new TeamProviderException("Commit failed", (Throwable)e);
        }
        catch (CommandException e) {
            throw new TeamProviderException("Commit failed", (Throwable)e);
        }
        catch (Exception e) {
            throw new TeamProviderException("Commit failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                try {
                    client.getConnection().close();
                }
                catch (IOException e) {
                    logger.error("Failed to close client connection", (Throwable)e);
                }
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private File[] calculateMissingFiles(Client client, File parentDir) throws IOException {
        ArrayList<File> filesToAdd = new ArrayList<File>();
        this.addMissingFiles(parentDir, client, filesToAdd);
        return filesToAdd.toArray(new File[filesToAdd.size()]);
    }

    private void addMissingFiles(File parentDir, Client client, List<File> filesToAdd) throws IOException {
        File[] files;
        Set knownFiles = client.getAllFiles(parentDir);
        for (File file : files = parentDir.listFiles(new CVSFileFilter())) {
            if (file.isDirectory()) {
                this.addMissingFiles(file, client, filesToAdd);
                continue;
            }
            if (knownFiles.contains(file)) continue;
            logger.info("CVS ADD {}", (Object)file);
            filesToAdd.add(file);
        }
    }

    public void commit(PropertyFileDescriptor descriptor, IProgressMonitor monitor) {
    }

    private Client createClient(ProjectVersion projectVersion) throws AuthenticationException, CommandAbortedException {
        CVSRoot root = CVSRoot.parse((String)((Project)projectVersion.getParent()).getRepositoryURI().toString());
        Connection connection = ConnectionFactory.getConnection((CVSRoot)root);
        if (connection instanceof PServerConnection) {
            PServerConnection pserver = (PServerConnection)connection;
            Preferences prefs = PreferencesUtil.scopeFor((Object)projectVersion.getParent());
            pserver.setUserName(prefs.get("cvs.username", "anonymous"));
            String password = prefs.get("cvs.password", null);
            if (password != null) {
                Scrambler scrambler = StandardScrambler.getInstance();
                pserver.setEncodedPassword(scrambler.scramble(password));
            }
        }
        Client client = new Client(connection, (AdminHandler)new StandardAdminHandler());
        File parentDir = new File(projectVersion.absoluteFilePath().toFileString());
        if (parentDir.exists()) {
            client.setLocalPath(parentDir.getAbsolutePath());
        } else {
            client.setLocalPath(parentDir.getParentFile().getAbsolutePath());
        }
        return client;
    }

    private GlobalOptions getGlobalOptions(Project project) {
        GlobalOptions options = new GlobalOptions();
        options.setCVSRoot(project.getRepositoryURI().toString());
        return options;
    }

    public Collection<PropertyFileDiff> update(ProjectVersion project, IProgressMonitor monitor) throws TeamProviderException {
        Client client = null;
        try {
            Client theClient;
            client = theClient = this.createClient(project);
            String fullPath = project.absolutPath().toFileString();
            monitor.beginTask("Updating", -1);
            UpdateCommand command = new UpdateCommand();
            DiffListener diffListener = new DiffListener(monitor, client, fullPath);
            client.getEventManager().addCVSListener((CVSListener)diffListener);
            command.setRecursive(true);
            command.setPruneDirectories(true);
            command.setFiles(new File(fullPath).listFiles(new CVSFileFilter()));
            command.setBuildDirectories(true);
            client.executeCommand((Command)command, this.getGlobalOptions((Project)project.getParent()));
            Collection<PropertyFileDiff> collection = diffListener.getDiff();
            return collection;
        }
        catch (AuthenticationException e) {
            throw new TeamProviderException("Update failed", (Throwable)e);
        }
        catch (CommandAbortedException e) {
            throw new TeamProviderException("Update failed", (Throwable)e);
        }
        catch (CommandException e) {
            throw new TeamProviderException("Update failed", (Throwable)e);
        }
        catch (Exception e) {
            throw new TeamProviderException("Update failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                try {
                    client.getConnection().close();
                }
                catch (IOException e) {
                    logger.error("Failed to close client connection", (Throwable)e);
                }
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public Collection<PropertyFileDiff> update(PropertyFileDescriptor descriptor, IProgressMonitor monitor) throws TeamProviderException {
        return null;
    }

    public Collection<PropertyFileDiff> reset(ProjectVersion project, IProgressMonitor monitor) throws TeamProviderException {
        Client client = null;
        try {
            Client theClient;
            client = theClient = this.createClient(project);
            String fullPath = project.absolutPath().toFileString();
            monitor.beginTask("Resetting", -1);
            UpdateCommand command = new UpdateCommand();
            DiffListener diffListener = new DiffListener(monitor, client, fullPath);
            client.getEventManager().addCVSListener((CVSListener)diffListener);
            command.setCleanCopy(true);
            command.setRecursive(true);
            command.setResetStickyOnes(true);
            command.setPruneDirectories(true);
            command.setFiles(new File(fullPath).listFiles(new CVSFileFilter()));
            command.setBuildDirectories(true);
            client.executeCommand((Command)command, this.getGlobalOptions((Project)project.getParent()));
            Collection<PropertyFileDiff> collection = diffListener.getDiff();
            return collection;
        }
        catch (AuthenticationException e) {
            throw new TeamProviderException("Reset failed", (Throwable)e);
        }
        catch (CommandAbortedException e) {
            throw new TeamProviderException("Reset failed", (Throwable)e);
        }
        catch (CommandException e) {
            throw new TeamProviderException("Reset failed", (Throwable)e);
        }
        catch (Exception e) {
            throw new TeamProviderException("Reset failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                try {
                    client.getConnection().close();
                }
                catch (IOException e) {
                    logger.error("Failed to close client connection", (Throwable)e);
                }
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

