/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.team.cvs.impl;

import org.eclipse.core.runtime.IProgressMonitor;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.commandLine.BasicListener;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileToRemoveEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;

class ProgressMonitorListener
extends BasicListener {
    private static final long serialVersionUID = 1L;
    private final IProgressMonitor monitor;
    private final Client client;
    private String basePath;

    public ProgressMonitorListener(IProgressMonitor monitor, Client client, String basePath) {
        this.monitor = monitor;
        this.client = client;
        this.basePath = basePath;
    }

    public void moduleExpanded(ModuleExpansionEvent arg0) {
        super.moduleExpanded(arg0);
        this.monitor.setTaskName(arg0.getModule());
        this.monitor.worked(1);
    }

    public void fileAdded(FileAddedEvent arg0) {
        super.fileAdded(arg0);
        if (this.monitor.isCanceled()) {
            this.client.abort();
        }
        String path = this.truncatePath(arg0.getFilePath());
        this.monitor.subTask(path);
        this.monitor.worked(1);
    }

    public void fileInfoGenerated(FileInfoEvent arg0) {
        super.fileInfoGenerated(arg0);
        if (this.monitor.isCanceled()) {
            this.client.abort();
        }
    }

    public void fileRemoved(FileRemovedEvent arg0) {
        super.fileRemoved(arg0);
        if (this.monitor.isCanceled()) {
            this.client.abort();
        }
        String path = this.truncatePath(arg0.getFilePath());
        this.monitor.subTask(path);
        this.monitor.worked(1);
    }

    public void fileToRemove(FileToRemoveEvent arg0) {
        super.fileToRemove(arg0);
        if (this.monitor.isCanceled()) {
            this.client.abort();
        }
        String path = this.truncatePath(arg0.getFilePath());
        this.monitor.subTask(path);
        this.monitor.worked(1);
    }

    public void fileUpdated(FileUpdatedEvent arg0) {
        super.fileUpdated(arg0);
        if (this.monitor.isCanceled()) {
            this.client.abort();
        }
        String path = this.truncatePath(arg0.getFilePath());
        this.monitor.subTask(path);
        this.monitor.worked(1);
    }

    private String truncatePath(String path) {
        String result = path.substring(this.basePath.length());
        if (result.length() > 50) {
            return "..." + result.substring(result.length() - 50);
        }
        return result;
    }

    protected String deresolve(String path) {
        return path.substring(this.basePath.length());
    }
}

