/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.team.git.config;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.EmailAddressValidator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.properties.Project;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.rest.ui.model.BooleanPreferencesPropertyModel;
import org.jabylon.rest.ui.model.EObjectPropertyModel;
import org.jabylon.rest.ui.model.PreferencesPropertyModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ControlGroup;
import org.jabylon.rest.ui.wicket.validators.UriValidator;
import org.osgi.service.prefs.Preferences;

public class GitConfigPanel
extends BasicPanel<Project> {
    private static final long serialVersionUID = 1L;
    private Preferences config;

    public GitConfigPanel(String id, IModel<Project> model, Preferences config) {
        super(id, model, new PageParameters());
        this.config = config;
    }

    protected void construct() {
        super.construct();
        EObjectPropertyModel repositoryURI = new EObjectPropertyModel(this.getModel(), (EStructuralFeature)PropertiesPackage.Literals.PROJECT__REPOSITORY_URI);
        ControlGroup uriGroup = new ControlGroup("uri-group", (IModel)this.nls("repository.uri.label", new Object[0]), (IModel)this.nls("repository.uri.help", new Object[0]));
        TextField uriField = new TextField("gitURI", (IModel)repositoryURI);
        uriField.setType(URI.class);
        uriField.add((IValidator)new UriValidator());
        uriField.setConvertEmptyInputStringToNull(true);
        uriField.setRequired(true);
        uriGroup.add(new Component[]{uriField});
        this.add(new Component[]{uriGroup});
        PreferencesPropertyModel usernameModel = new PreferencesPropertyModel(this.config, "git.username", "");
        ControlGroup usernameGroup = new ControlGroup("username-group", (IModel)this.nls("username.label", new Object[0]));
        usernameGroup.add(new Component[]{new TextField("gitUsername", (IModel)usernameModel)});
        this.add(new Component[]{usernameGroup});
        PreferencesPropertyModel passwordModel = new PreferencesPropertyModel(this.config, "git.password", "");
        ControlGroup passwordGroup = new ControlGroup("password-group", (IModel)this.nls("password.label", new Object[0]));
        PasswordTextField passwordTextField = new PasswordTextField("gitPassword", (IModel)passwordModel);
        passwordTextField.setResetPassword(false);
        passwordTextField.setRequired(false);
        passwordGroup.add(new Component[]{passwordTextField});
        this.add(new Component[]{passwordGroup});
        PreferencesPropertyModel emailModel = new PreferencesPropertyModel(this.config, "git.email", "jabylon@example.org");
        ControlGroup emailGroup = new ControlGroup("email-group", (IModel)this.nls("email.label", new Object[0]), (IModel)this.nls("email.help", new Object[0]));
        TextField emailField = new TextField("gitEmail", (IModel)emailModel);
        emailField.setRequired(true);
        emailField.add((IValidator)EmailAddressValidator.getInstance());
        emailGroup.add(new Component[]{emailField});
        this.add(new Component[]{emailGroup});
        PreferencesPropertyModel messageModel = new PreferencesPropertyModel(this.config, "git.message", "");
        ControlGroup messageGroup = new ControlGroup("message-group", (IModel)this.nls("message.label", new Object[0]), (IModel)this.nls("message.help", new Object[0]));
        TextArea messageField = new TextArea("gitCommitMessage", (IModel)messageModel);
        messageField.setRequired(false);
        messageGroup.add(new Component[]{messageField});
        this.add(new Component[]{messageGroup});
        BooleanPreferencesPropertyModel changeIdModel = new BooleanPreferencesPropertyModel(this.config, "git.changeId", false);
        ControlGroup changeIdGroup = new ControlGroup("changeId-group", (IModel)this.nls("changeId.label", new Object[0]), (IModel)this.nls("changeId.help", new Object[0]));
        CheckBox changeIdCheckbox = new CheckBox("changeId", (IModel)changeIdModel);
        changeIdGroup.add(new Component[]{changeIdCheckbox});
        this.add(new Component[]{changeIdGroup});
        PreferencesPropertyModel privateKeyModel = new PreferencesPropertyModel(this.config, "git.private.key", "");
        ControlGroup privateKeyGroup = new ControlGroup("private-key-group", (IModel)this.nls("private.key.label", new Object[0]), (IModel)this.nls("private.key.help", new Object[0]));
        TextArea privateKeyField = new TextArea("private-key", (IModel)privateKeyModel);
        privateKeyField.setRequired(false);
        privateKeyGroup.add(new Component[]{privateKeyField});
        this.add(new Component[]{privateKeyGroup});
    }
}

