/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.team.git.config;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.eclipse.jgit.transport.RefSpec;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.rest.ui.model.AttachableModel;
import org.jabylon.rest.ui.model.BooleanPreferencesPropertyModel;
import org.jabylon.rest.ui.model.PreferencesPropertyModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ControlGroup;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.security.CommonPermissions;
import org.osgi.service.prefs.Preferences;

public class GitVersionConfigPanel
extends BasicPanel<ProjectVersion> {
    private static final long serialVersionUID = 1L;

    public GitVersionConfigPanel(String id, IModel<ProjectVersion> model, Preferences config) {
        super(id, model);
        PreferencesPropertyModel pushRefspecModel = new PreferencesPropertyModel(config, "git.push.refspec", "");
        ControlGroup pushRefspecGroup = new ControlGroup("push-refspec-group", (IModel)this.nls("push.refspec.label", new Object[0]), (IModel)this.nls("push.refspec.help", new Object[0]));
        TextField refspecTextField = new TextField("push-refspec", (IModel)pushRefspecModel);
        refspecTextField.add((IValidator)new RefspecValidator());
        refspecTextField.setRequired(false);
        refspecTextField.setConvertEmptyInputStringToNull(false);
        pushRefspecGroup.add(new Component[]{refspecTextField});
        this.add(new Component[]{pushRefspecGroup});
        BooleanPreferencesPropertyModel rebase = new BooleanPreferencesPropertyModel(config, "git.rebase", true);
        ControlGroup rebaseGroup = new ControlGroup("rebase-group", (IModel)this.nls("rebase.label", new Object[0]), (IModel)this.nls("rebase.help", new Object[0]));
        CheckBox rebaseCheckbox = new CheckBox("rebase", (IModel)rebase);
        rebaseGroup.add(new Component[]{rebaseCheckbox});
        this.add(new Component[]{rebaseGroup});
    }

    private static class RefspecValidator
    implements IValidator<String> {
        private static final long serialVersionUID = 1L;

        private RefspecValidator() {
        }

        public void validate(IValidatable<String> validatable) {
            String value = (String)validatable.getValue();
            try {
                new RefSpec(value);
            }
            catch (Exception e) {
                validatable.error((IValidationError)new ValidationError(e.getMessage()));
            }
        }
    }

    public static class GitVersionConfigSection
    extends AbstractConfigSection<ProjectVersion> {
        private static final long serialVersionUID = 1L;

        private boolean gitSelected(IModel<ProjectVersion> model) {
            return "Git".equals(this.getProject(model).getTeamProvider());
        }

        Project getProject(IModel<ProjectVersion> model) {
            if (model instanceof AttachableModel) {
                AttachableModel m = (AttachableModel)model;
                return (Project)m.getParent().getObject();
            }
            return (Project)((ProjectVersion)model.getObject()).getParent();
        }

        public WebMarkupContainer doCreateContents(String id, IModel<ProjectVersion> input, Preferences config) {
            GitVersionConfigPanel panel = new GitVersionConfigPanel(id, input, config);
            panel.setVisible(this.gitSelected(input));
            return panel;
        }

        public boolean isVisible(IModel<ProjectVersion> input, Preferences config) {
            return this.gitSelected(input) && super.isVisible(input, config);
        }

        public void commit(IModel<ProjectVersion> input, Preferences config) {
        }

        public String getRequiredPermission() {
            Project project = this.getProject((IModel<ProjectVersion>)this.getModel());
            String projectName = null;
            if (project != null) {
                projectName = project.getName();
            }
            return CommonPermissions.constructPermission((String[])new String[]{"Project", projectName, "config"});
        }
    }
}

