/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.team.svn.config;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.properties.Project;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.rest.ui.model.EObjectPropertyModel;
import org.jabylon.rest.ui.model.PreferencesPropertyModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ControlGroup;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.security.CommonPermissions;
import org.osgi.service.prefs.Preferences;

public class SVNConfigPanel
extends BasicPanel<Project> {
    private static final long serialVersionUID = 1L;

    public SVNConfigPanel(String id, IModel<Project> model, Preferences config) {
        super(id, model);
        EObjectPropertyModel repositoryURI = new EObjectPropertyModel(model, (EStructuralFeature)PropertiesPackage.Literals.PROJECT__REPOSITORY_URI);
        ControlGroup uriGroup = new ControlGroup("uri-group", (IModel)this.nls("uri.label", new Object[0]));
        TextField uriField = new TextField("inputURI", (IModel)repositoryURI);
        uriField.setType(URI.class);
        uriField.setConvertEmptyInputStringToNull(true);
        uriGroup.add(new Component[]{uriField});
        this.add(new Component[]{uriGroup});
        ControlGroup moduleGroup = new ControlGroup("module-group", (IModel)this.nls("module.label", new Object[0]));
        PreferencesPropertyModel moduleModel = new PreferencesPropertyModel(config, "svn.module", "");
        moduleGroup.add(new Component[]{new TextField("inputModule", (IModel)moduleModel)});
        this.add(new Component[]{moduleGroup});
        ControlGroup usernameGroup = new ControlGroup("username-group", (IModel)this.nls("username.label", new Object[0]));
        PreferencesPropertyModel usernameModel = new PreferencesPropertyModel(config, "svn.username", "");
        usernameGroup.add(new Component[]{new TextField("inputUsername", (IModel)usernameModel)});
        this.add(new Component[]{usernameGroup});
        ControlGroup passwordGroup = new ControlGroup("password-group", (IModel)this.nls("password.label", new Object[0]));
        PreferencesPropertyModel passwordModel = new PreferencesPropertyModel(config, "svn.password", "");
        PasswordTextField passwordTextField = new PasswordTextField("inputPassword", (IModel)passwordModel);
        passwordTextField.setResetPassword(false);
        passwordTextField.setRequired(false);
        passwordGroup.add(new Component[]{passwordTextField});
        this.add(new Component[]{passwordGroup});
    }

    public static class SVNConfigSection
    extends AbstractConfigSection<Project> {
        private static final long serialVersionUID = 1L;

        private boolean svnSelected(IModel<Project> model) {
            return "SVN".equals(((Project)model.getObject()).getTeamProvider());
        }

        public WebMarkupContainer doCreateContents(String id, IModel<Project> input, Preferences config) {
            return new SVNConfigPanel(id, input, config);
        }

        public void commit(IModel<Project> input, Preferences config) {
        }

        public boolean isVisible(IModel<Project> input, Preferences config) {
            return this.svnSelected(input);
        }

        public String getRequiredPermission() {
            String projectName = null;
            if (this.getDomainObject() != null) {
                projectName = ((Project)this.getDomainObject()).getName();
            }
            return CommonPermissions.constructPermission((String[])new String[]{"Project", projectName, "config"});
        }
    }
}

