/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.team.svn.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jabylon.properties.DiffKind;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertyFileDiff;
import org.jabylon.team.svn.impl.ProgressMonitorHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

class DiffHandler
extends ProgressMonitorHandler {
    private List<PropertyFileDiff> diff = new ArrayList<PropertyFileDiff>();

    public DiffHandler(IProgressMonitor monitor, String basePath) {
        super(monitor, basePath);
    }

    @Override
    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        super.handleEvent(event, progress);
        SVNEventAction action = event.getAction();
        if (action.equals(SVNEventAction.UPDATE_REPLACE) || action.equals(SVNEventAction.UPDATE_UPDATE)) {
            PropertyFileDiff fileDiff = PropertiesFactory.eINSTANCE.createPropertyFileDiff();
            fileDiff.setKind(DiffKind.MODIFY);
            fileDiff.setOldPath(this.deresolve(event.getFile().getAbsolutePath()));
            fileDiff.setNewPath(this.deresolve(event.getFile().getAbsolutePath()));
            this.diff.add(fileDiff);
        } else if (action.equals(SVNEventAction.UPDATE_ADD)) {
            PropertyFileDiff fileDiff = PropertiesFactory.eINSTANCE.createPropertyFileDiff();
            fileDiff.setKind(DiffKind.ADD);
            fileDiff.setNewPath(this.deresolve(event.getFile().getAbsolutePath()));
            this.diff.add(fileDiff);
        } else if (action.equals(SVNEventAction.UPDATE_DELETE)) {
            PropertyFileDiff fileDiff = PropertiesFactory.eINSTANCE.createPropertyFileDiff();
            fileDiff.setKind(DiffKind.REMOVE);
            fileDiff.setOldPath(this.deresolve(event.getFile().getAbsolutePath()));
            this.diff.add(fileDiff);
        }
    }

    public List<PropertyFileDiff> getDiff() {
        return this.diff;
    }
}

