/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.team.svn.impl;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;

class ProgressMonitorHandler
implements ISVNEventHandler {
    private final IProgressMonitor monitor;
    private String basePath;

    public ProgressMonitorHandler(IProgressMonitor monitor, String basePath) {
        this.monitor = monitor;
        this.basePath = basePath;
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        File file = event.getFile();
        if (file != null) {
            this.monitor.subTask(this.truncatePath(this.deresolve(file.getPath())));
            this.monitor.worked(1);
        }
    }

    protected String truncatePath(String path) {
        if (path.length() > 50) {
            return "..." + path.substring(path.length() - 50);
        }
        return path;
    }

    protected String deresolve(String path) {
        return path.substring(this.basePath.length());
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.monitor.isCanceled()) {
            throw new SVNCancelException();
        }
    }
}

