/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.team.svn.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.jabylon.common.team.TeamProvider;
import org.jabylon.common.team.TeamProviderException;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.PropertyFileDiff;
import org.jabylon.team.svn.impl.DiffHandler;
import org.jabylon.team.svn.impl.ProgressMonitorHandler;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

@Component(enabled=true, immediate=true)
@Service
public class SVNTeamProvider
implements TeamProvider {
    private static final Logger logger = LoggerFactory.getLogger(SVNTeamProvider.class);
    @Property(value={"SVN"})
    private static String KEY_KIND = "kind";

    public void checkout(ProjectVersion project, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.beginTask("Checking out", 100);
        SVNClientManager manager = null;
        try {
            manager = this.createSVNClientManager(project);
            this.checkDirectories(project);
            monitor.worked(5);
            SVNURL svnurl = this.createSVNURL(project);
            logger.info("Checking out " + svnurl);
            File targetDir = new File(project.absoluteFilePath().path());
            manager.getUpdateClient().setEventHandler((ISVNEventHandler)new ProgressMonitorHandler((IProgressMonitor)sub.newChild(1000), targetDir.getPath()));
            long revision = manager.getUpdateClient().doCheckout(svnurl, targetDir, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, true);
            logger.info("Checkout successful at revision {}", (Object)revision);
        }
        catch (SVNException e) {
            this.cleanupProjectVersionDirectory(project);
            throw new TeamProviderException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.cleanupProjectVersionDirectory(project);
            throw new TeamProviderException("Checkout failed", (Throwable)e);
        }
        finally {
            if (manager != null) {
                manager.dispose();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private SVNURL createSVNURL(ProjectVersion projectVersion) throws SVNException {
        Preferences prefs = PreferencesUtil.scopeFor((Object)projectVersion.getParent());
        URI uri = ((Project)projectVersion.getParent()).getRepositoryURI();
        String branch = projectVersion.getName();
        if (!"trunk".equals(branch)) {
            uri = uri.appendSegment("branches");
        }
        uri = uri.appendSegment(branch);
        if (prefs.get("svn.module", null) != null) {
            uri = uri.appendSegments(prefs.get("svn.module", null).split("/"));
        }
        return SVNURL.parseURIEncoded((String)uri.toString());
    }

    private static void init() {
        SVNRepositoryFactoryImpl.setup();
        DAVRepositoryFactory.setup();
        FSRepositoryFactory.setup();
    }

    private void cleanupProjectVersionDirectory(ProjectVersion project) {
        File versionDir = new File(project.absolutPath().toFileString());
        try {
            versionDir.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkDirectories(ProjectVersion projectVersion) {
        File projectDir = new File(((Project)projectVersion.getParent()).absoluteFilePath().toFileString());
        if (!projectDir.exists() && !projectDir.mkdirs()) {
            throw new TeamProviderException("Checkout failed. Unable to create project directory");
        }
    }

    public void commit(ProjectVersion project, IProgressMonitor monitor) {
        SVNClientManager manager = null;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            manager = this.createSVNClientManager(project);
            String fullPath = project.absolutPath().toFileString();
            subMon.beginTask("Calculating local changes", 100);
            List<File> filesToAdd = this.calculateChangedFiles(new File(fullPath), manager, (IProgressMonitor)subMon.newChild(20));
            SVNWCClient wcClient = manager.getWCClient();
            for (File file : filesToAdd) {
                logger.info("SVN ADD {}", (Object)file.getPath());
                wcClient.doAdd(file, true, false, false, SVNDepth.FILES, false, true);
            }
            subMon.worked(10);
            SVNCommitClient commitClient = manager.getCommitClient();
            subMon.setTaskName("Committing");
            commitClient.setEventHandler((ISVNEventHandler)new ProgressMonitorHandler((IProgressMonitor)subMon.newChild(70), fullPath));
            if (filesToAdd.isEmpty()) {
                logger.info("Nothing to commit");
            } else {
                SVNCommitInfo commitInfo = commitClient.doCommit(filesToAdd.toArray(new File[filesToAdd.size()]), false, "Jabylon Auto-Sync Up", null, null, false, false, SVNDepth.FILES);
                if (commitInfo.getErrorMessage() != null) {
                    throw new TeamProviderException(commitInfo.getErrorMessage().getMessage(), commitInfo.getErrorMessage().getCause());
                }
                logger.info("SVN commit successfully at revision {}", (Object)commitInfo.getNewRevision());
            }
        }
        catch (SVNException e) {
            throw new TeamProviderException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TeamProviderException("Commit failed", (Throwable)e);
        }
        finally {
            if (manager != null) {
                manager.dispose();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private SVNClientManager createSVNClientManager(ProjectVersion project) throws SVNException {
        SVNClientManager manager = SVNClientManager.newInstance((ISVNOptions)SVNWCUtil.createDefaultOptions((boolean)false), (ISVNAuthenticationManager)this.createAuthenticationManager(project));
        manager.createRepository(this.createSVNURL(project), true);
        return manager;
    }

    private ISVNAuthenticationManager createAuthenticationManager(ProjectVersion projectVersion) {
        Preferences prefs = PreferencesUtil.scopeFor((Object)projectVersion.getParent());
        String username = prefs.get("svn.username", null);
        String password = prefs.get("svn.password", null);
        return SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
    }

    private List<File> calculateChangedFiles(File parentDir, SVNClientManager manager, IProgressMonitor monitor) throws IOException, SVNException {
        final ArrayList<File> filesToAdd = new ArrayList<File>();
        SVNStatusClient statusClient = manager.getStatusClient();
        monitor.beginTask("Computing changed files", 100);
        statusClient.setEventHandler((ISVNEventHandler)new ProgressMonitorHandler(monitor, parentDir.getAbsolutePath()));
        statusClient.doStatus(parentDir, SVNRevision.WORKING, SVNDepth.INFINITY, false, false, false, false, new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) throws SVNException {
                SVNStatusType type = status.getNodeStatus();
                if (type.equals(SVNStatusType.STATUS_MISSING)) {
                    filesToAdd.add(status.getFile());
                } else if (type.equals(SVNStatusType.STATUS_MODIFIED)) {
                    filesToAdd.add(status.getFile());
                } else if (type.equals(SVNStatusType.STATUS_UNVERSIONED)) {
                    filesToAdd.add(status.getFile());
                } else if (type.equals(SVNStatusType.STATUS_ADDED)) {
                    filesToAdd.add(status.getFile());
                } else if (type.equals(SVNStatusType.STATUS_DELETED)) {
                    filesToAdd.add(status.getFile());
                }
            }
        }, null);
        monitor.done();
        return filesToAdd;
    }

    public void commit(PropertyFileDescriptor descriptor, IProgressMonitor monitor) {
    }

    public Collection<PropertyFileDiff> update(ProjectVersion project, IProgressMonitor monitor) throws TeamProviderException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor);
        SVNClientManager manager = null;
        try {
            manager = this.createSVNClientManager(project);
            String fullPath = project.absolutPath().toFileString();
            subMon.beginTask("Fetching remote changes", 100);
            DiffHandler handler = new DiffHandler((IProgressMonitor)subMon, fullPath);
            manager.getUpdateClient().setEventHandler((ISVNEventHandler)handler);
            long revision = manager.getUpdateClient().doUpdate(new File(fullPath), SVNRevision.HEAD, SVNDepth.INFINITY, false, false);
            logger.info("SVN update to revision {} successfull", (Object)revision);
            List<PropertyFileDiff> list = handler.getDiff();
            return list;
        }
        catch (SVNException e) {
            throw new TeamProviderException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new TeamProviderException("Update failed", (Throwable)e);
        }
        finally {
            if (manager != null) {
                manager.dispose();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public Collection<PropertyFileDiff> update(PropertyFileDescriptor descriptor, IProgressMonitor monitor) throws TeamProviderException {
        return Collections.emptyList();
    }

    static {
        SVNTeamProvider.init();
    }
}

