/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.updatecenter.repository.impl;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.jabylon.cdo.server.ServerConstants;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.common.util.config.DynamicConfigUtil;
import org.jabylon.updatecenter.repository.OBRException;
import org.jabylon.updatecenter.repository.OBRRepositoryService;
import org.jabylon.updatecenter.repository.ResourceFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(enabled=true, immediate=true)
@Service
public class OBRRepositoryConnectorImpl
implements OBRRepositoryService {
    private static final String DEFAULT_REPOSITORY = "http://jabylon.org/maven/repository.xml";
    @Reference(bind="bindAdmin")
    private RepositoryAdmin admin;
    private static final Logger logger = LoggerFactory.getLogger(OBRRepositoryConnectorImpl.class);
    private static final Pattern BUNDLE_PATTERN = Pattern.compile("(.*?)_(.*?)\\.jar");
    private static final Comparator<Version> COMPARATOR = new OSGiVersionComparator();
    private File pluginDir;
    private BundleContext context;

    @Activate
    public void activate() {
        this.pluginDir = new File(new File(ServerConstants.WORKING_DIR), "addons");
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        this.context = bundle.getBundleContext();
        this.deployAddons(this.pluginDir);
    }

    @Override
    public List<Bundle> listInstalledBundles() {
        List<Bundle> resources = Arrays.asList(this.context.getBundles());
        return resources;
    }

    public void bindAdmin(RepositoryAdmin admin) {
        this.admin = admin;
    }

    private void deployAddons(File pluginDir) {
        File[] addons = pluginDir.listFiles();
        if (addons == null) {
            return;
        }
        List<String> bundleFiles = this.getHighestBundleVersions(pluginDir.list());
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (String addonName : bundleFiles) {
            try {
                File addon = new File(pluginDir, addonName);
                String uri = addon.toURI().toString();
                Bundle bundle = this.context.getBundle(uri);
                if (bundle == null) {
                    logger.info("Installing Addon {}", (Object)addonName);
                    bundle = this.context.installBundle(uri);
                }
                bundles.add(bundle);
            }
            catch (BundleException e) {
                logger.error("Failed to deploy addon " + addonName);
            }
        }
        for (Bundle bundle : bundles) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                logger.error("Failed to start addon " + bundle.getSymbolicName());
            }
        }
    }

    protected List<String> getHighestBundleVersions(String ... filenames) {
        if (filenames == null) {
            return Collections.emptyList();
        }
        TreeMultimap map = TreeMultimap.create((Comparator)Collator.getInstance(), (Comparator)new VersionComparator());
        for (String string : filenames) {
            Matcher matcher = BUNDLE_PATTERN.matcher(string);
            if (matcher.matches()) {
                String name = matcher.group(1);
                String version = matcher.group(2);
                map.put((Object)name, (Object)version);
                continue;
            }
            logger.warn("{} does not match the pattern {}. Skipping", (Object)string, (Object)BUNDLE_PATTERN);
        }
        Set entrySet = map.asMap().entrySet();
        ArrayList<String> result = new ArrayList<String>(entrySet.size());
        for (Map.Entry entry : entrySet) {
            result.add((String)entry.getKey() + "_" + (String)((Collection)entry.getValue()).iterator().next() + ".jar");
        }
        return result;
    }

    protected String getHighestVersion(List<String> versions) {
        String versionName = versions.get(0);
        Version highest = Version.parseVersion((String)versionName);
        for (String currentName : versions) {
            Version current = Version.parseVersion((String)currentName);
            if (current.compareTo(highest) <= 0) continue;
            highest = current;
        }
        return highest.toString();
    }

    @Override
    public List<Resource> getAvailableResources(ResourceFilter filter) {
        List<Resource> filteredResources = new ArrayList<Resource>();
        List<Bundle> bundles = this.listInstalledBundles();
        Multimap<String, Bundle> map = this.buildMap(bundles);
        try {
            Resource[] resources;
            Repository repository = this.getRepository();
            for (Resource resource : resources = repository.getResources()) {
                if (!this.applies(filter, map, resource)) continue;
                filteredResources.add(resource);
            }
            if (filter == ResourceFilter.PLUGIN) {
                filteredResources = this.removeOldVersions(filteredResources);
            }
        }
        catch (Exception e) {
            logger.error("Failed to discover resources with filter " + filter, (Throwable)e);
        }
        return filteredResources;
    }

    private List<Resource> removeOldVersions(List<Resource> resources) {
        TreeMultimap map = TreeMultimap.create((Comparator)Collator.getInstance(), (Comparator)new ResourceComparator());
        for (Resource bundle : resources) {
            map.put((Object)bundle.getSymbolicName(), (Object)bundle);
        }
        resources.clear();
        Set entries = map.asMap().entrySet();
        for (Map.Entry entry : entries) {
            resources.add((Resource)((Collection)entry.getValue()).iterator().next());
        }
        return resources;
    }

    private Multimap<String, Bundle> buildMap(List<Bundle> bundles) {
        TreeMultimap result = TreeMultimap.create((Comparator)Collator.getInstance(), (Comparator)new BundleVersionComparator());
        for (Bundle bundle : bundles) {
            result.put((Object)bundle.getSymbolicName(), (Object)bundle);
        }
        return result;
    }

    private Repository getRepository() {
        Preferences node = PreferencesUtil.workspaceScope().node("update");
        String url = node.get("update.url", DEFAULT_REPOSITORY);
        try {
            return this.admin.addRepository(url);
        }
        catch (Exception e) {
            logger.error("Failed to add repository " + url, (Throwable)e);
            return null;
        }
    }

    private boolean applies(ResourceFilter filter, Multimap<String, Bundle> bundles, Resource resource) {
        switch (filter) {
            case ALL: {
                return true;
            }
            case PLUGIN: {
                String[] categories = resource.getCategories();
                if (categories == null) {
                    return false;
                }
                for (String string : categories) {
                    if (!"Jabylon-Plugin".equals(string)) continue;
                    return !bundles.containsKey((Object)resource.getSymbolicName());
                }
                return false;
            }
            case INSTALLABLE: {
                return !bundles.containsKey((Object)resource.getSymbolicName());
            }
            case UPDATEABLE: {
                Collection installed = bundles.get((Object)resource.getSymbolicName());
                if (installed.isEmpty()) {
                    return false;
                }
                return COMPARATOR.compare(((Bundle)installed.iterator().next()).getVersion(), resource.getVersion()) > 0;
            }
            case INSTALLED: {
                Collection available = bundles.get((Object)resource.getSymbolicName());
                for (Bundle bundle : available) {
                    if (!bundle.getVersion().equals((Object)resource.getVersion())) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void install(String resourceId) throws OBRException {
        String filter = MessageFormat.format("({0}={1})", "id", resourceId);
        try {
            Resource[] resources = this.admin.discoverResources(filter);
            if (resources.length > 0) {
                this.install(resources[0]);
            }
        }
        catch (InvalidSyntaxException e) {
            logger.error("Invalid OSGi filter " + filter, (Throwable)e);
        }
    }

    @Override
    public void install(Resource ... resources) throws OBRException {
        Bundle systemBundle;
        FrameworkWiring wiring;
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Resource resource : resources) {
            try {
                Bundle bundle = this.context.installBundle(this.downloadBundle(resource));
                bundles.add(bundle);
            }
            catch (BundleException e) {
                OBRException exception = new OBRException("Failed to start bundle " + resource, e);
                logger.error("Plugin Installation failed", (Throwable)e);
                throw exception;
            }
            catch (MalformedURLException e) {
                OBRException exception = new OBRException("Incorrect URI for bundle " + resource, e);
                logger.error("Plugin Installation failed", (Throwable)e);
                throw exception;
            }
            catch (IOException e) {
                OBRException exception = new OBRException("Failed to download bundle " + resource, e);
                logger.error("Plugin Installation failed", (Throwable)e);
                throw exception;
            }
        }
        boolean needRefresh = false;
        for (Bundle bundle : bundles) {
            logger.info("Starting Bundle " + bundle);
            try {
                needRefresh |= this.checkIfUpdate(bundle);
                bundle.start();
            }
            catch (BundleException e) {
                logger.error("Failed to start bundle " + bundle.getSymbolicName(), (Throwable)e);
                throw new OBRException("Failed to start bundle " + bundle.getSymbolicName(), e);
            }
        }
        if (!bundles.isEmpty()) {
            DynamicConfigUtil.refresh();
        }
        if (needRefresh && (wiring = (FrameworkWiring)(systemBundle = this.context.getBundle(0L)).adapt(FrameworkWiring.class)) != null) {
            logger.info("Executing package refresh after update");
            wiring.refreshBundles(null, new FrameworkListener[0]);
        }
    }

    private boolean checkIfUpdate(Bundle bundle) {
        Bundle[] bundles = this.context.getBundles();
        boolean updated = false;
        for (Bundle other : bundles) {
            if (other == bundle || !other.getSymbolicName().equals(bundle.getSymbolicName())) continue;
            try {
                if (other.getState() == 1) break;
                updated = true;
                if (this.isSingleton(other)) {
                    logger.info("{}:{} is a singleton. Uninstalling due to an update", (Object)other.getSymbolicName(), (Object)other.getVersion());
                    other.uninstall();
                    continue;
                }
                logger.info("Stopping {}:{} due to an update", (Object)other.getSymbolicName(), (Object)other.getVersion());
                other.stop();
            }
            catch (BundleException e) {
                logger.error("Failed to stop " + other, (Throwable)e);
            }
        }
        return updated;
    }

    private boolean isSingleton(Bundle other) {
        String string = (String)other.getHeaders().get("Bundle-SymbolicName");
        return string != null && string.contains("singleton:=true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadBundle(Resource resource) throws MalformedURLException, IOException {
        File destination;
        String uriString = resource.getURI();
        URI uri = URI.create(uriString);
        InputStream stream = null;
        OutputStream out = null;
        try {
            stream = uri.toURL().openStream();
            this.pluginDir.mkdirs();
            destination = new File(this.pluginDir, resource.getSymbolicName() + "_" + resource.getVersion() + ".jar");
            out = new FileOutputStream(destination);
            byte[] buffer = new byte[4096];
            int read = 0;
            while ((read = stream.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
        return destination.toURI().toString();
    }

    @Override
    public Resource[] findResources(String id) {
        String filter = "({0}={1})";
        filter = MessageFormat.format(filter, "id", id);
        try {
            return this.admin.discoverResources(filter);
        }
        catch (InvalidSyntaxException e) {
            logger.error("Invalid OSGi filter " + filter, (Throwable)e);
            return new Resource[0];
        }
    }

    protected void unbindAdmin(RepositoryAdmin repositoryAdmin) {
        if (this.admin == repositoryAdmin) {
            this.admin = null;
        }
    }

    private static class ResourceComparator
    implements Comparator<Resource> {
        private ResourceComparator() {
        }

        @Override
        public int compare(Resource o1, Resource o2) {
            Version v1 = o1.getVersion();
            Version v2 = o2.getVersion();
            return COMPARATOR.compare(v1, v2);
        }
    }

    private static class VersionComparator
    implements Comparator<String> {
        private VersionComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            Version v1 = Version.parseVersion((String)o1);
            Version v2 = Version.parseVersion((String)o2);
            return COMPARATOR.compare(v1, v2);
        }
    }

    private static class OSGiVersionComparator
    implements Comparator<Version> {
        private OSGiVersionComparator() {
        }

        @Override
        public int compare(Version v1, Version v2) {
            if (!"SNAPSHOT".equals(v1.getQualifier()) || !"SNAPSHOT".equals(v2.getQualifier())) {
                if ("SNAPSHOT".equals(v1.getQualifier())) {
                    if (v1.getMajor() == v2.getMajor() && v1.getMicro() == v2.getMicro() && v1.getMinor() == v2.getMinor()) {
                        return 1;
                    }
                } else if ("SNAPSHOT".equals(v2.getQualifier()) && v1.getMajor() == v2.getMajor() && v1.getMicro() == v2.getMicro() && v1.getMinor() == v2.getMinor()) {
                    return -1;
                }
            }
            return -v1.compareTo(v2);
        }
    }

    private static class BundleVersionComparator
    implements Comparator<Bundle> {
        private BundleVersionComparator() {
        }

        @Override
        public int compare(Bundle o1, Bundle o2) {
            Version v1 = o1.getVersion();
            Version v2 = o2.getVersion();
            return COMPARATOR.compare(v1, v2);
        }
    }
}

