/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.updatecenter.repository.ui;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.felix.bundlerepository.Resource;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.updatecenter.repository.OBRException;
import org.jabylon.updatecenter.repository.OBRRepositoryService;
import org.jabylon.updatecenter.repository.ResourceFilter;
import org.jabylon.updatecenter.repository.ui.ResourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatecenterTabContent
extends BasicPanel<ResourceFilter> {
    private static final long serialVersionUID = 1L;
    @Inject
    private OBRRepositoryService repositoryConnector;
    private IModel<List<? extends ResourceWrapper>> resources;
    private static final Logger logger = LoggerFactory.getLogger(UpdatecenterTabContent.class);

    public UpdatecenterTabContent(String id, IModel<ResourceFilter> model, PageParameters parameters) {
        super(id, model, parameters);
        this.resources = Model.ofList(new LoadBundlesFunction().apply(model));
        Form<Void> form = new Form<Void>("form"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit() {
                super.onSubmit();
                List list = (List)UpdatecenterTabContent.this.resources.getObject();
                ArrayList<Resource> toBeChanged = new ArrayList<Resource>();
                for (ResourceWrapper wrapper : list) {
                    Resource[] resources;
                    if (!wrapper.isChecked()) continue;
                    for (Resource resource2 : resources = UpdatecenterTabContent.this.repositoryConnector.findResources(wrapper.getId())) {
                        logger.info("Installing Resource {}", (Object)resource2.getSymbolicName());
                        toBeChanged.add(resource2);
                    }
                }
                try {
                    UpdatecenterTabContent.this.repositoryConnector.install(toBeChanged.toArray(new Resource[toBeChanged.size()]));
                }
                catch (OBRException e) {
                    if (e.getCause() != null) {
                        this.getSession().error((Serializable)((Object)e.getCause().getMessage()));
                    }
                    this.getSession().error((Serializable)((Object)e.getMessage()));
                }
                if (!toBeChanged.isEmpty()) {
                    PageParameters parameters = new PageParameters();
                    parameters.set(0, (Object)"settings");
                    this.setResponsePage(this.getPage().getClass(), parameters);
                }
            }
        };
        this.add(new Component[]{form});
        ListView<ResourceWrapper> resourceView = new ListView<ResourceWrapper>("row", this.resources){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<ResourceWrapper> item) {
                ResourceWrapper resourceWrapper = (ResourceWrapper)item.getModelObject();
                Resource resource = resourceWrapper.getResource();
                String name = resource.getSymbolicName();
                item.add(new Component[]{new Label("name", name)});
                String description = (String)resource.getProperties().get("description");
                if (description == null) {
                    description = resource.getPresentationName();
                }
                item.add(new Component[]{new Label("description", description)});
                item.add(new Component[]{new Label("version", resource.getVersion().toString())});
                item.add(new Component[]{new CheckBox("install", (IModel)new PropertyModel((Object)item.getModel(), "checked"))});
            }
        };
        resourceView.setReuseItems(true);
        form.add(new Component[]{resourceView});
    }

    private class LoadBundlesFunction
    implements Function<IModel<ResourceFilter>, List<ResourceWrapper>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private LoadBundlesFunction() {
        }

        public List<ResourceWrapper> apply(IModel<ResourceFilter> model) {
            List<Resource> list = UpdatecenterTabContent.this.repositoryConnector.getAvailableResources((ResourceFilter)model.getObject());
            ArrayList<ResourceWrapper> result = new ArrayList<ResourceWrapper>(list.size());
            for (Resource resource : list) {
                result.add(new ResourceWrapper(resource));
            }
            return result;
        }
    }
}

